/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.parsing;

import com.kingdee.bos.asm.AnnotationVisitor;
import com.kingdee.bos.asm.ClassVisitor;
import com.kingdee.bos.asm.FieldVisitor;
import com.kingdee.bos.asm.Type;
import com.kingdee.bos.bsf.annotation.Description;
import com.kingdee.bos.bsf.parsing.DescriptionAnnotationVisitor;
import com.kingdee.bos.bsf.parsing.FieldMetadata;
import com.kingdee.bos.bsf.parsing.POJOMetadata;

class POJOClassVisitor
extends ClassVisitor {
    private final POJOMetadata pojo;

    public POJOClassVisitor(POJOMetadata pojo) {
        super(262144);
        this.pojo = pojo;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (superName != null) {
            this.pojo.setSuperName(Type.getObjectType((String)superName).getDescriptor());
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (Type.getDescriptor(Description.class).equals(desc)) {
            return new DescriptionAnnotationVisitor(this.pojo);
        }
        return null;
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        FieldMetadata field = new FieldMetadata(desc);
        field.setName(name);
        this.pojo.addField(field);
        return new POJOFieldVisitor(field);
    }

    static class POJOFieldVisitor
    extends FieldVisitor {
        private final FieldMetadata field;

        public POJOFieldVisitor(FieldMetadata field) {
            super(262144);
            this.field = field;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (Type.getDescriptor(Description.class).equals(desc)) {
                return new DescriptionAnnotationVisitor(this.field);
            }
            return null;
        }
    }
}

