/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.parsing;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.asm.ClassReader;
import com.kingdee.bos.asm.ClassVisitor;
import com.kingdee.bos.bsf.parsing.POJOClassVisitor;
import com.kingdee.bos.bsf.parsing.POJOMetadata;
import com.kingdee.bos.bsf.parsing.PathParser;
import com.kingdee.bos.bsf.parsing.ServiceParseException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;

public class POJOParser {
    private final List<URL> urls = new ArrayList<URL>();
    private final ClassLoader classLoader;

    public POJOParser(URL home) throws BOSException {
        try {
            this.urls.add(new URL(home, "classes/"));
            this.urls.addAll(new PathParser().expandPaths(new File(new URL(home, "lib/*.jar").toURI()).getAbsolutePath()));
        }
        catch (Exception e) {
            throw new ServiceParseException("pojo parse error. can't find jars. url:" + home, e);
        }
        this.classLoader = new URLClassLoader(this.urls.toArray(new URL[0]), ClassLoader.getSystemClassLoader());
    }

    public POJOMetadata parse(String className) throws BOSException {
        POJOMetadata pojo = new POJOMetadata(className);
        InputStream in = null;
        try {
            in = this.classLoader.getResourceAsStream(className.replace('.', '/') + ".class");
            POJOClassVisitor cv = new POJOClassVisitor(pojo);
            ClassReader cr = new ClassReader(in);
            cr.accept((ClassVisitor)cv, 7);
        }
        catch (Exception e) {
            throw new ServiceParseException("pojo parse error. class:" + className, e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new ServiceParseException("pojo parse error. class:" + className, e);
                }
            }
        }
        return pojo;
    }
}

