/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.parsing;

import java.io.File;
import java.net.URISyntaxException;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.util.ResourceUtils;

public class ParserContext {
    private String resource;
    private String parentLocation;
    private String absoluteLocation;
    private boolean isClassPath = false;
    private ClassLoader resourceClassLoader;

    public ParserContext(String parentLocation, String resource) {
        this.parentLocation = parentLocation;
        this.resource = resource;
    }

    public ClassLoader getResourceClassLoader() {
        return this.resourceClassLoader;
    }

    public void setResourceClassLoader(ClassLoader classLoader) {
        this.resourceClassLoader = classLoader;
        this.isClassPath = true;
    }

    public ParserContext(String resource) {
        this.resource = resource;
    }

    public boolean isClassPath() {
        return this.isClassPath;
    }

    public void setClassPath(boolean isClassPath) {
        this.isClassPath = isClassPath;
    }

    public String getResource() {
        return this.resource;
    }

    String getAbsoluteResourceLocation() {
        if (this.absoluteLocation != null) {
            return this.absoluteLocation;
        }
        String separator = File.separator;
        if (this.parentLocation != null && this.parentLocation.endsWith(File.separator)) {
            separator = "";
        }
        try {
            boolean isAbsolute;
            boolean bl = isAbsolute = ResourcePatternUtils.isUrl((String)this.resource) || ResourceUtils.toURI((String)this.resource).isAbsolute();
            this.absoluteLocation = isAbsolute || this.parentLocation == null ? this.resource : this.parentLocation + separator + this.resource;
        }
        catch (URISyntaxException e) {
            this.absoluteLocation = this.parentLocation == null ? this.resource : this.parentLocation + separator + this.resource;
        }
        return this.absoluteLocation;
    }

    String getAbsolutePath() {
        if (this.absoluteLocation == null) {
            this.getAbsoluteResourceLocation();
        }
        if (this.absoluteLocation == null) {
            return null;
        }
        int idx = this.absoluteLocation.lastIndexOf(47);
        if (idx > 0) {
            return this.absoluteLocation.substring(0, idx);
        }
        idx = this.absoluteLocation.lastIndexOf(92);
        if (idx > 0) {
            return this.absoluteLocation.substring(0, idx);
        }
        return null;
    }
}

