/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.parsing;

import com.kingdee.bos.BOSException;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;

public class PathParser {
    private static final Logger logger = Logger.getLogger(PathParser.class);
    private static final String SPLIT_D = "[;" + File.pathSeparator + "]";

    public List<URL> expandPaths(String paths) {
        String[] items = paths.split(SPLIT_D);
        ArrayList<URL> urls = new ArrayList<URL>();
        for (int i = 0; i < items.length; ++i) {
            urls.addAll(this.expendPath(items[i]));
        }
        return urls;
    }

    private List<URL> expendPath(String path) {
        File file;
        if (path == null || path.length() == 0) {
            return Collections.emptyList();
        }
        int pos = path.indexOf("*");
        if (pos == -1 && (file = new File(path)).exists()) {
            try {
                ArrayList<URL> urls = new ArrayList<URL>(1);
                urls.add(file.toURI().toURL());
                return urls;
            }
            catch (Exception e) {
                logger.error((Object)"BSF expand path error.", (Throwable)e);
                return Collections.emptyList();
            }
        }
        String dir = path.substring(0, pos);
        final String suffix = path.substring(pos + 1);
        try {
            File fdir = new File(dir);
            File[] files = fdir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(suffix);
                }
            });
            if (files == null) {
                logger.warn((Object)(dir + " has't " + suffix));
                return Collections.emptyList();
            }
            ArrayList<File> normalJarFiles = new ArrayList<File>();
            ArrayList<URL> urls = new ArrayList<URL>();
            for (int i = 0; i < files.length; ++i) {
                normalJarFiles.add(files[i]);
            }
            Comparator<File> fileTimeStampComparator = new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    long l2;
                    long l1 = o1.lastModified();
                    if (l1 > (l2 = o2.lastModified())) {
                        return -1;
                    }
                    if (1L == l2) {
                        return 0;
                    }
                    return 1;
                }
            };
            Collections.sort(normalJarFiles, fileTimeStampComparator);
            for (File file2 : normalJarFiles) {
                urls.add(file2.toURI().toURL());
            }
            return urls;
        }
        catch (Exception e) {
            logger.error((Object)"BSF expand path error.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    static interface Handler {
        public void convert(String var1, URL var2, URL var3) throws BOSException;
    }
}

