/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.parsing;

import com.kingdee.bos.asm.AnnotationVisitor;
import com.kingdee.bos.asm.ClassVisitor;
import com.kingdee.bos.asm.MethodVisitor;
import com.kingdee.bos.asm.Type;
import com.kingdee.bos.bsf.annotation.Description;
import com.kingdee.bos.bsf.annotation.Service;
import com.kingdee.bos.bsf.parsing.DescriptionAnnotationVisitor;
import com.kingdee.bos.bsf.parsing.OperationMetadata;
import com.kingdee.bos.bsf.parsing.ParamMetadata;
import com.kingdee.bos.bsf.parsing.ServiceAnnotationVisitor;
import com.kingdee.bos.bsf.parsing.ServiceMetadata;
import com.kingdee.bos.bsf.parsing.ServiceMethodVisitor;

class ServiceClassVisitor
extends ClassVisitor {
    private final ServiceMetadata service;

    public ServiceClassVisitor(ServiceMetadata service) {
        super(262144);
        this.service = service;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (Type.getDescriptor(Service.class).equals(desc)) {
            return new ServiceAnnotationVisitor(this.service);
        }
        if (this.service.enableDescription && Type.getDescriptor(Description.class).equals(desc)) {
            return new DescriptionAnnotationVisitor(this.service);
        }
        return null;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        Type[] params;
        OperationMetadata operation = new OperationMetadata(name);
        operation.enableDescription = this.service.enableDescription;
        for (Type p : params = Type.getArgumentTypes((String)desc)) {
            ParamMetadata param = new ParamMetadata(p.getDescriptor());
            param.enableDescription = operation.enableDescription;
            operation.addParam(param);
        }
        operation.setReturnType(Type.getReturnType((String)desc).getDescriptor());
        this.service.addOperation(operation);
        return new ServiceMethodVisitor(operation);
    }
}

