/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.parsing;

import com.kingdee.bos.bsf.parsing.ConfigurationParseException;
import com.kingdee.bos.bsf.parsing.ParserContext;
import com.kingdee.bos.bsf.parsing.ResourceNotFoundException;
import com.kingdee.bos.bsf.parsing.ServiceParseException;
import com.kingdee.bos.util.XMLParser;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class XmlFileReader {
    public Element read(URL path) throws ServiceParseException {
        Element root = null;
        InputStream is = null;
        try {
            is = new FileInputStream(new File(path.toURI()));
            root = XMLParser.parseXML((InputStream)is).getRootElement();
        }
        catch (Exception e) {
            throw new ServiceParseException("read config error. res:" + path, e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return root;
    }

    public Element read(ParserContext parserContext) throws ConfigurationParseException {
        Element root = null;
        String resource = parserContext.getAbsoluteResourceLocation();
        InputStream is = null;
        try {
            is = this.readFile(parserContext, parserContext.isClassPath());
            if (is == null) {
                throw new ResourceNotFoundException("\u8bfb\u53d6\u8d44\u6e90\u6587\u4ef6\u3010" + resource + "\u3011\u5931\u8d25");
            }
            root = XMLParser.parseXML((InputStream)is).getRootElement();
        }
        catch (JDOMException e) {
            throw new ConfigurationParseException(e);
        }
        catch (IOException e) {
            throw new ConfigurationParseException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return root;
    }

    private InputStream readFile(ParserContext parserContext, boolean isClassPath) {
        String resource = parserContext.getAbsoluteResourceLocation();
        try {
            if (!isClassPath) {
                return new FileInputStream(resource);
            }
            return this.getClassLoader(parserContext).getResourceAsStream(resource);
        }
        catch (FileNotFoundException e) {
            throw new ResourceNotFoundException("\u627e\u4e0d\u5230\u8d44\u6e90\u6587\u4ef6\u3010" + resource + "\u3011");
        }
    }

    public Element read(String xmlString) {
        InputStream is = this.getInputStreamFromString(xmlString);
        return this.read(is);
    }

    public Element read(InputStream is) {
        try {
            return XMLParser.parseXML((InputStream)is).getRootElement();
        }
        catch (JDOMException e) {
            throw new ConfigurationParseException(e);
        }
        catch (IOException e) {
            throw new ConfigurationParseException(e);
        }
    }

    private InputStream getInputStreamFromString(String str) {
        return new ByteArrayInputStream(str.getBytes());
    }

    private ClassLoader getClassLoader(ParserContext parserContext) {
        if (parserContext.getResourceClassLoader() != null) {
            return parserContext.getResourceClassLoader();
        }
        return this.getClass().getClassLoader();
    }
}

