/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.parsing;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.bsf.ServiceRegistry;
import com.kingdee.bos.bsf.parsing.ComponentMetadata;
import com.kingdee.bos.bsf.parsing.ComponentParser;
import com.kingdee.bos.bsf.parsing.IConfigurationParser;
import com.kingdee.bos.bsf.parsing.ServiceMetadata;
import com.kingdee.bos.bsf.parsing.XmlFileReader;
import com.kingdee.bos.bsf.service.IServiceRegister;
import java.net.URL;
import org.jdom2.Element;

public class XmlServicesConfigParser
implements IConfigurationParser {
    static final String SERVICE = "service";
    static final String COMPONENT = "component";
    static final String COMPONENT_SCAN = "component-scan";
    private final URL path;
    private final ComponentParser componentParser;
    private final IServiceRegister serviceRegister;
    private static final String NAME_PROPERTY = "name";
    private static final String INTERFACE_PROPERTY = "interface";
    private static final String IMPLEMENTATION_PROPERTY = "implementation";

    public XmlServicesConfigParser(URL home, URL path, IServiceRegister serviceRegister) throws BOSException {
        this.path = path;
        this.serviceRegister = serviceRegister;
        this.componentParser = new ComponentParser(home);
    }

    @Override
    public void parse() throws BOSException {
        XmlFileReader reader = new XmlFileReader();
        Element root = reader.read(this.path);
        this.doParse(root);
    }

    private void doParse(Element root) throws BOSException {
        for (Element element : root.getChildren()) {
            String name = element.getName();
            if (COMPONENT.equals(name)) {
                this.parseComponent(element);
                continue;
            }
            if (SERVICE.equals(name)) {
                this.parseService(element);
                continue;
            }
            if (!COMPONENT_SCAN.equals(name)) continue;
            this.parseComponentScan(element);
        }
    }

    private void parseComponent(Element element) throws BOSException {
        this.addService(element.getText());
    }

    void addService(String className) throws BOSException {
        if (className == null || className.length() == 0) {
            return;
        }
        ComponentMetadata component = this.componentParser.parse(className, false);
        String componentName = component.getName();
        for (ServiceMetadata s : component.listService()) {
            ServiceRegistry service = new ServiceRegistry(componentName == null ? s.getName() : componentName + "$" + s.getName(), s.getSignature(), component.getSignature());
            this.serviceRegister.registerService(service);
        }
    }

    private void parseComponentScan(Element element) throws BOSException {
        String regex = element.getText();
        if (regex == null || regex.length() == 0) {
            return;
        }
        for (String c : this.componentParser.getClasses(regex)) {
            this.addService(c);
        }
    }

    private void parseService(Element element) {
        String impl = element.getAttributeValue(IMPLEMENTATION_PROPERTY);
        if (impl == null) {
            impl = element.getAttributeValue("class");
        }
        ServiceRegistry service = new ServiceRegistry(element.getAttributeValue(NAME_PROPERTY), element.getAttributeValue(INTERFACE_PROPERTY), impl);
        this.serviceRegister.registerService(service);
    }
}

