/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.bsf.Composite;
import com.kingdee.bos.bsf.deploy.BSFDeployException;
import com.kingdee.bos.bsf.parsing.Properties;
import com.kingdee.bos.bsf.service.ServiceConfigException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.log4j.Logger;

public class Configuration {
    private static final Logger logger = Logger.getLogger(Configuration.class);
    public final URL home;
    public final List<URL> configPaths;
    public static final String MODULE_DIR = "modules";
    public static final String REPOSITORY_DIR = "repository";
    public static final String DOCUMENT_DIR = "document";
    public static final String ROOT_DIR = "EAS_HOME";
    public static final String META_DIR = "META-INF";
    public static final String LIB_DIR = "lib";
    public static final String CLASSES_DIR = "classes";
    public static final String TMP_DIR = "tmp";
    public static final String CONFIG_DIR = "config";
    public static final String DESC_FILE = "module.desc";
    public static final String MODULE_KEY = "module";
    public static final String VERSION_KEY = "version";
    public static final String STATE_KEY = "state";
    public static final String ALIAS_KEY = "alias";
    public static final String DESCRIPTION_KEY = "description";

    public Configuration(URL home, List<URL> configPaths) {
        this.home = home;
        this.configPaths = configPaths;
    }

    public static File getRootDir() {
        return new File(System.getProperty(ROOT_DIR) + "/server/services");
    }

    public static File getModuleDir() {
        return new File(Configuration.getRootDir(), MODULE_DIR);
    }

    public static File getRepositoryDir() {
        return new File(Configuration.getRootDir(), REPOSITORY_DIR);
    }

    public static File getDocumentDir() {
        return new File(Configuration.getRootDir(), DOCUMENT_DIR);
    }

    public static File getConfigDir() {
        return new File(Configuration.getRootDir(), CONFIG_DIR);
    }

    public static File getMetaDir(File parent) {
        return new File(parent, META_DIR);
    }

    public static File getModuleDescFile(File parent) {
        return new File(parent, DESC_FILE);
    }

    public static URL toURL(File file) throws BOSException {
        if (file == null) {
            return null;
        }
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new ServiceConfigException("can't convert file to url. file:" + file.getPath());
        }
    }

    public static File toFile(URL url) throws BOSException {
        if (url == null) {
            return null;
        }
        try {
            return new File(url.getPath());
        }
        catch (Exception e) {
            throw new BSFDeployException("can't convert url to file. url:" + url, e);
        }
    }

    public static Composite getComposite(File desc, boolean read) throws BOSException {
        if (desc != null && desc.exists()) {
            Properties info = new Properties();
            Reader stream = null;
            try {
                stream = new InputStreamReader((InputStream)new FileInputStream(desc), "UTF-8");
                info.load(stream);
            }
            catch (Exception e) {
                throw new ServiceConfigException("BSF can't parse file:" + desc.getPath(), e);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            String name = info.getProperty(MODULE_KEY);
            String version = info.getProperty(VERSION_KEY);
            String state = info.getProperty(STATE_KEY);
            String alias = info.getProperty(ALIAS_KEY);
            String description = info.getProperty(DESCRIPTION_KEY);
            if (name == null || version == null) {
                throw new ServiceConfigException("BSF can't get module name and version in file:" + desc.getPath());
            }
            if (read) {
                return Composite.getInstance(name, version);
            }
            int s = 1;
            if (state != null && state.length() > 0) {
                try {
                    s = Integer.parseInt(state);
                }
                catch (Exception e) {
                    logger.warn((Object)("state parse error. state:" + state + " module:" + desc.getPath()));
                }
            }
            Composite composite = Composite.getInstance(name, version, s);
            composite.setAlias(alias);
            composite.setDescription(description);
            logger.info((Object)("BSF " + composite + " installed."));
            return composite;
        }
        throw new BSFDeployException("can't find file:" + desc.getPath());
    }
}

