/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.bsf.Composite;
import com.kingdee.bos.bsf.Domain;
import com.kingdee.bos.bsf.IServiceRepository;
import com.kingdee.bos.bsf.ServiceRepositoryFactory;
import com.kingdee.bos.bsf.service.IServiceRepositoryLoader;
import com.kingdee.bos.bsf.service.ServiceRepository;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DefaultServiceRepositoryFactory
implements ServiceRepositoryFactory {
    private static final Logger logger = Logger.getLogger(DefaultServiceRepositoryFactory.class);
    private final Map<Composite, IServiceRepository> cache = new HashMap<Composite, IServiceRepository>();

    @Override
    public IServiceRepository getInstance(Composite composite) {
        IServiceRepository repository = this.cache.get(composite);
        if (repository == null && this.cache.isEmpty()) {
            Domain.getInstance(composite);
            repository = this.cache.get(composite);
        }
        return repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Composite> iterate() throws BOSException {
        IServiceRepositoryLoader loader = Domain.utility.getUtility(IServiceRepositoryLoader.class);
        List<Composite> composites = loader.iterate();
        if (composites != null) {
            Map<Composite, IServiceRepository> map = this.cache;
            synchronized (map) {
                this.cache.clear();
                for (Composite c : composites) {
                    this.cache.put(c, new ServiceRepository(c));
                }
            }
        }
        return composites;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Composite> incrementalIterate() throws BOSException {
        IServiceRepositoryLoader loader = Domain.utility.getUtility(IServiceRepositoryLoader.class);
        List<Composite> composites = loader.incrementalIterate();
        if (composites != null) {
            Map<Composite, IServiceRepository> map = this.cache;
            synchronized (map) {
                for (Composite c : composites) {
                    this.cache.put(c, new ServiceRepository(c));
                }
            }
        }
        return composites;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Composite composite) {
        IServiceRepositoryLoader loader = Domain.utility.getUtility(IServiceRepositoryLoader.class);
        loader.remove(composite);
        Map<Composite, IServiceRepository> map = this.cache;
        synchronized (map) {
            this.cache.remove(composite);
        }
    }
}

