/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.service;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.Converter;
import com.kingdee.bos.bsf.ServiceException;
import com.kingdee.bos.bsf.Snapshot;
import com.kingdee.bos.bsf.annotation.Param;
import com.kingdee.bos.bsf.type.ClassGenerator;
import com.kingdee.bos.bsf.type.FieldInfo;
import com.kingdee.bos.bsf.type.Reflect;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.json.Kson;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class MethodConverter
implements Converter {
    private final Method method;
    private final String key;
    private final Gson gson;
    private Snapshot snapshot;

    MethodConverter(String key, Method method) {
        this.method = method;
        this.key = key;
        this.gson = Kson.getGson();
    }

    @Override
    public void setSnapshot(Snapshot snapshot) {
        this.snapshot = snapshot;
    }

    @Override
    public Object[] convertParam(Context ctx, String json) throws BOSException {
        Class<?>[] paramTypes = this.method.getParameterTypes();
        Annotation[][] annotations = this.method.getParameterAnnotations();
        Object[] args = new Object[paramTypes.length];
        if (paramTypes.length > 0) {
            FieldInfo[] fields = new FieldInfo[paramTypes.length];
            Param param = null;
            for (int i = 0; i < paramTypes.length; ++i) {
                for (Annotation a : annotations[i]) {
                    if (!(a instanceof Param)) continue;
                    param = (Param)a;
                    break;
                }
                if (param != null) {
                    fields[i] = new FieldInfo(param.value(), paramTypes[i]);
                }
                param = null;
            }
            Object values = JSONUtils.convertJsonToObject((Context)ctx, (String)json, (Type)TypeToken.get(this.getClass(fields)).getType(), (Gson)this.gson);
            for (int i = 0; i < paramTypes.length; ++i) {
                args[i] = Reflect.getter(values, fields[i].getName());
            }
        }
        return args;
    }

    private Class<?> getClass(FieldInfo[] fields) throws BOSException {
        Snapshot ss = this.snapshot;
        if (ss == null) {
            throw new ServiceException("generate operation param object error. snapshot is null. key:" + this.key);
        }
        String k = this.key + "_" + ss.getSeq();
        Track track = (Track)ss.get("convert");
        if (track == null) {
            track = ss.putIfAbsent("convert", new Track());
        }
        if (track.contains(k)) {
            return ss.loadClass(k);
        }
        try {
            new ClassGenerator(ss.getRuntime()).generateJavaBean(k, fields);
        }
        catch (Exception e) {
            throw new ServiceException("generate operation param object error. key:" + k, e);
        }
        track.add(k);
        return ss.loadClass(k);
    }

    @Override
    public String convertResult(Context ctx, Object result) throws BOSException {
        if (result == null) {
            return null;
        }
        return JSONUtils.convertObjectToJson((Context)ctx, (Object)result, (Gson)this.gson);
    }

    @Override
    public Object[] convertParam(Context ctx, Map<String, Object> args) throws BOSException {
        Class<?>[] paramTypes = this.method.getParameterTypes();
        Annotation[][] annotations = this.method.getParameterAnnotations();
        Object[] params = new Object[paramTypes.length];
        if (paramTypes.length > 0) {
            Param param = null;
            for (int i = 0; i < paramTypes.length; ++i) {
                for (Annotation a : annotations[i]) {
                    if (!(a instanceof Param)) continue;
                    param = (Param)a;
                    break;
                }
                if (param != null) {
                    params[i] = args.get(param.value());
                }
                param = null;
            }
        }
        return params;
    }

    static class Track {
        private final Set<String> keys = new HashSet<String>();

        Track() {
        }

        boolean contains(String key) {
            return this.keys.contains(key);
        }

        synchronized void add(String key) {
            this.keys.add(key);
        }
    }
}

