/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.GeniusBOSFactory;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.QueryServiceLocator;
import com.kingdee.bos.bsf.IServiceLocator;
import com.kingdee.bos.bsf.ServiceLocatorException;
import com.kingdee.bos.bsf.ServiceRegistry;
import com.kingdee.bos.bsf.service.ServiceRegistryGetterFactory;
import com.kingdee.bos.orm.template.ORMObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ServiceLocator
implements IServiceLocator {
    private static final IServiceLocator _instance = new ServiceLocator();
    private volatile ServiceContext context = null;

    public static IServiceLocator getInstance() {
        return _instance;
    }

    private ServiceLocator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceContext getServiceContext(Context ctx) {
        if (this.context == null) {
            ServiceLocator serviceLocator = this;
            synchronized (serviceLocator) {
                if (this.context == null) {
                    ServiceContext sctx = new ServiceContext();
                    try {
                        List<ServiceRegistry> registries = ServiceRegistryGetterFactory.getInstance(ctx).get();
                        if (registries != null) {
                            for (ServiceRegistry r : registries) {
                                sctx.registerImplementation(r.getName(), r.getInterfaceName(), r.getClassName());
                            }
                        }
                    }
                    catch (BOSException e) {
                        throw new ServiceLocatorException("get service registry error.", e);
                    }
                    this.context = sctx;
                }
            }
        }
        return this.context;
    }

    @Override
    public Object lookupService(String serviceName) throws ServiceLocatorException {
        return this.lookupService(null, serviceName);
    }

    @Override
    public Object lookupService(Context ctx, String serviceName) throws ServiceLocatorException {
        assert (serviceName != null);
        ServiceContext sc = this.getServiceContext(ctx);
        String serviceClassName = sc.getImplementation(serviceName);
        String serviceInterfaceName = sc.getInterface(serviceName);
        if (serviceClassName == null) {
            throw new ServiceLocatorException("\u5728\u670d\u52a1\u6ce8\u518c\u5e93\u4e2d\u672a\u627e\u5230\u670d\u52a1\u3010" + serviceName + "\u3011");
        }
        return ServiceFactory.createServiceInstance(ctx, serviceName, serviceInterfaceName, serviceClassName);
    }

    private static final class ServiceContext {
        private final Map<String, Service> name2Service = new HashMap<String, Service>();

        private ServiceContext() {
        }

        public void registerImplementation(String service, String interfac, String implClass) {
            if (service == null || interfac == null || implClass == null) {
                return;
            }
            this.name2Service.put(service, new Service(interfac, implClass));
        }

        public String getInterface(String service) {
            Service s = this.name2Service.get(service);
            if (s != null) {
                return s.interfac;
            }
            return null;
        }

        public String getImplementation(String service) {
            Service s = this.name2Service.get(service);
            if (s != null) {
                return s.implementation;
            }
            return null;
        }

        public void reset() {
            this.name2Service.clear();
        }

        private static class Service {
            final String interfac;
            final String implementation;

            Service(String interfac, String implementation) {
                this.interfac = interfac;
                this.implementation = implementation;
            }
        }
    }

    private static final class ServiceFactory {
        private static final String CLIENT_EASROOT = "easclient.root";

        private ServiceFactory() {
        }

        private static boolean isClient() {
            return System.getProperties().keySet().contains(CLIENT_EASROOT);
        }

        static Object createServiceInstance(Context ctx, String serviceName, String serviceInterfaceName, String serviceClassName) {
            Class<?> serviceClass;
            Class<?> serviceInterface;
            try {
                serviceInterface = Class.forName(serviceInterfaceName);
            }
            catch (ClassNotFoundException e) {
                throw new ServiceLocatorException("\u627e\u4e0d\u5230\u670d\u52a1\u3010" + serviceName + "\u3011\u7684\u63a5\u53e3\u7c7b\u3010" + serviceInterfaceName + "\u3011", e);
            }
            try {
                serviceClass = Class.forName(serviceClassName);
            }
            catch (ClassNotFoundException e) {
                throw new ServiceLocatorException("\u627e\u4e0d\u5230\u670d\u52a1\u3010" + serviceName + "\u3011\u7684\u5b9e\u73b0\u7c7b\u3010" + serviceClassName + "\u3011", e);
            }
            if (IBOSObject.class.isAssignableFrom(serviceInterface) && ORMObject.class.isAssignableFrom(serviceClass)) {
                return ServiceFactory.createBOSObject(ctx, serviceName, serviceClassName, serviceInterface);
            }
            try {
                return serviceClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new ServiceLocatorException("\u521b\u5efa\u670d\u52a1\u3010" + serviceName + "\u3011\u7684\u666e\u901a\u670d\u52a1\u5bf9\u8c61\u5b9e\u4f8b\u51fa\u9519\u3002", e);
            }
            catch (IllegalAccessException e) {
                throw new ServiceLocatorException("\u521b\u5efa\u670d\u52a1\u3010" + serviceName + "\u3011\u7684\u666e\u901a\u670d\u52a1\u5bf9\u8c61\u5b9e\u4f8b\u51fa\u9519\u3002", e);
            }
        }

        private static Object createBOSObject(Context ctx, String serviceName, String serviceClassName, Class serviceInterface) {
            if (ServiceFactory.isClient()) {
                if (ctx == null) {
                    return ServiceFactory.createRemoteBOSObject(serviceName, serviceInterface, serviceClassName);
                }
                return ServiceFactory.createRemoteBOSObjectWithObjectContext(ctx, serviceName, serviceInterface, serviceClassName);
            }
            if (ctx == null) {
                throw new ServiceLocatorException("\u521b\u5efa\u670d\u52a1\u3010" + serviceName + "\u3011\u7684\u670d\u52a1\u7aef\u672c\u5730\u5bf9\u8c61\u5b9e\u4f8b\u7f3a\u5c11Context\u3002");
            }
            return ServiceFactory.createLocalBOSObject(ctx, serviceName, serviceInterface, serviceClassName);
        }

        private static Object createRemoteBOSObjectWithObjectContext(Context ctx, String serviceName, Class serviceInterface, String serviceClassName) {
            try {
                return GeniusBOSFactory.createRemoteBOSObjectWithObjectContext((String)serviceClassName, (Class)serviceInterface, (Context)ctx);
            }
            catch (BOSException e) {
                throw new ServiceLocatorException("\u521b\u5efa\u670d\u52a1\u3010" + serviceName + "\u3011\u7684\u8fdc\u7a0bBOS\u670d\u52a1\u5bf9\u8c61\u5b9e\u4f8b\u51fa\u9519\u3002", e);
            }
        }

        private static Object createRemoteBOSObject(String serviceName, Class serviceInterface, String serviceClassName) {
            try {
                return BOSObjectFactory.createRemoteBOSObject((String)QueryServiceLocator.getCurrentServiceURL((boolean)true), (String)serviceClassName, (Class)serviceInterface);
            }
            catch (BOSException e) {
                throw new ServiceLocatorException("\u521b\u5efa\u670d\u52a1\u3010" + serviceName + "\u3011\u7684\u8fdc\u7a0bBOS\u670d\u52a1\u5bf9\u8c61\u5b9e\u4f8b\u51fa\u9519\u3002", e);
            }
        }

        private static Object createLocalBOSObject(Context ctx, String serviceName, Class serviceInterface, String serviceClassName) {
            try {
                return BOSObjectFactory.createBOSObject((Context)ctx, (String)serviceClassName, (Class)serviceInterface);
            }
            catch (BOSException e) {
                throw new ServiceLocatorException("\u521b\u5efa\u670d\u52a1\u3010" + serviceName + "\u3011\u7684\u672c\u5730BOS\u670d\u52a1\u5bf9\u8c61\u5b9e\u4f8b\u51fa\u9519\u3002", e);
            }
        }
    }
}

