/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.service;

import com.kingdee.bos.bsf.Composite;
import com.kingdee.bos.bsf.Domain;
import com.kingdee.bos.bsf.ServiceRegistry;
import com.kingdee.bos.bsf.ServiceRepositoryFactory;
import com.kingdee.bos.bsf.service.IServiceRepositoryLoader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

final class ServiceMapping {
    private static final Logger logger;
    private static final Map<String, String> mapping;

    ServiceMapping() {
    }

    static String getModule(String service) {
        return mapping.get(service);
    }

    static {
        Composite[] composites;
        logger = Logger.getLogger(ServiceMapping.class);
        mapping = new HashMap<String, String>();
        Domain.getInstance(Composite.OLD_BSF);
        for (Composite c : composites = Domain.utility.getUtility(IServiceRepositoryLoader.class).getComposites()) {
            try {
                List<ServiceRegistry> registries = Domain.utility.getUtility(ServiceRepositoryFactory.class).getInstance(c).getServiceRegistries();
                if (registries == null) continue;
                for (ServiceRegistry r : registries) {
                    String m = mapping.put(r.getName(), c.getName());
                    if (m == null || m.equals(c.getName())) continue;
                    logger.error((Object)("service[" + r.getName() + "] duplicate between module[" + m + "] and module[" + c.getName() + "], and the latter will override the former."));
                }
            }
            catch (Exception e) {
                logger.error((Object)("create service mapping error. composite:" + c), (Throwable)e);
            }
        }
    }
}

