/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.service;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.Domain;
import com.kingdee.bos.bsf.IService;
import com.kingdee.bos.bsf.OpenAPI;
import com.kingdee.bos.bsf.ServiceException;
import com.kingdee.bos.bsf.facade.FacadeFileScan;
import com.kingdee.bos.bsf.manage.FacadeMethodBean;
import com.kingdee.bos.bsf.service.ServiceMapping;
import com.kingdee.bos.bsf.service.VersionManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.util.Map;

public class ServiceObject
extends AbstractBOSObject
implements IService {
    public ServiceObject(Context ctx) {
        super(ctx);
        this.registerInterface(IService.class, this);
    }

    public ServiceObject() {
        this.registerInterface(IService.class, this);
    }

    public BOSObjectType getType() {
        return BOSObjectType.create((String)"BSFS");
    }

    @Override
    public String invoke(String service, String operation, String argJson) throws BOSException {
        return this.invoke(null, service, operation, argJson);
    }

    @Override
    public String invoke(String id, String service, String operation, String argJson) throws BOSException {
        String version;
        if (service.endsWith(".facade")) {
            FacadeMethodBean fmb;
            if (service.startsWith("test:")) {
                service = service.substring("test:".length());
                argJson = argJson.replace("\\t", "").replace("\\r", "").replace("\\n", "").replace("\\\"", "\"").trim();
                argJson = argJson.replaceFirst("\"", "").substring(0, argJson.length() - 2);
            }
            if ((fmb = OpenAPI.findAPI(service, operation)) != null) {
                ClassLoader cl = ServiceObject.class.getClassLoader();
                try {
                    String businessImplName = FacadeFileScan.getInstance().getFacadeBean(service.replace(".", "/").replace("/facade", ".facade")).get_businessImplName();
                    Class<?> factoryClass = cl.loadClass(businessImplName + "Factory");
                    Method instanceMethod = OpenAPI.getFacadeInstanceMethod(factoryClass);
                    Context context = this.getContext();
                    Object instaceFactory = instanceMethod.invoke(factoryClass, this.getContext());
                    return OpenAPI.invoke(context, instaceFactory, operation, argJson, fmb);
                }
                catch (Exception e) {
                    throw new BOSException(e.getMessage());
                }
            }
            throw new ServiceException("can't find matched openapi.  facade:" + service + " method:" + operation);
        }
        String module = ServiceMapping.getModule(service);
        Domain domain = Domain.getInstance(module, version = VersionManager.getVersion(id));
        if (domain != null) {
            return domain.invokeService(this.getContext(), service, operation, argJson);
        }
        throw new ServiceException("can't find matched domain. module:" + module + " version:" + version + " service:" + service + " id:" + id);
    }

    @Override
    public String invoke(String uri, String argJson) throws BOSException {
        if (StringUtils.isEmpty((String)uri)) {
            throw new ServiceException("service's uri is null");
        }
        String[] ss = (uri = uri.replace('\\', '/')).split("/");
        if (ss.length == 2) {
            return this.invoke(ss[0], ss[1], argJson);
        }
        if (ss.length == 3) {
            return this.invoke(ss[0], ss[1], ss[2], argJson);
        }
        throw new ServiceException("invalid service's uri:" + uri);
    }

    @Override
    public Object invoke(String service, String operation, Map<String, Object> args) throws BOSException {
        return this.invoke(null, service, operation, args);
    }

    @Override
    public Object invoke(String id, String service, String operation, Map<String, Object> args) throws BOSException {
        String version;
        String module = ServiceMapping.getModule(service);
        Domain domain = Domain.getInstance(module, version = VersionManager.getVersion(id));
        if (domain != null) {
            return domain.invokeService(this.getContext(), service, operation, args);
        }
        throw new ServiceException("can't find matched domain. module:" + module + " version:" + version + " service:" + service + " id:" + id);
    }

    @Override
    public Object invoke(String uri, Map<String, Object> args) throws BOSException {
        if (StringUtils.isEmpty((String)uri)) {
            throw new ServiceException("service's uri is null");
        }
        String[] ss = (uri = uri.replace('\\', '/')).split("/");
        if (ss.length == 2) {
            return this.invoke(ss[0], ss[1], args);
        }
        if (ss.length == 3) {
            return this.invoke(ss[0], ss[1], ss[2], args);
        }
        throw new ServiceException("invalid service's uri:" + uri);
    }
}

