/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.bsf.Composite;
import com.kingdee.bos.bsf.Domain;
import com.kingdee.bos.bsf.IServiceRepository;
import com.kingdee.bos.bsf.ServiceRegistry;
import com.kingdee.bos.bsf.parsing.XmlServicesConfigParser;
import com.kingdee.bos.bsf.service.Configuration;
import com.kingdee.bos.bsf.service.IServiceRegister;
import com.kingdee.bos.bsf.service.IServiceRepositoryLoader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

class ServiceRepository
implements IServiceRepository,
IServiceRegister {
    private final Composite composite;
    private final List<ServiceRegistry> serviceRegistries = new ArrayList<ServiceRegistry>();
    private URL home = null;
    private volatile boolean isInited = false;

    ServiceRepository(Composite composite) {
        this.composite = composite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init() throws BOSException {
        if (this.isInited) {
            return;
        }
        List<ServiceRegistry> list = this.serviceRegistries;
        synchronized (list) {
            if (this.isInited) {
                return;
            }
            IServiceRepositoryLoader loader = Domain.utility.getUtility(IServiceRepositoryLoader.class);
            Configuration config = loader.getConfiguration(this.composite);
            for (URL url : config.configPaths) {
                new XmlServicesConfigParser(config.home, url, this).parse();
            }
            this.home = config.home;
            this.isInited = true;
        }
    }

    @Override
    public Composite getComposite() {
        return this.composite;
    }

    @Override
    public URL getHome() throws BOSException {
        this.init();
        return this.home;
    }

    @Override
    public List<ServiceRegistry> getServiceRegistries() throws BOSException {
        this.init();
        return this.serviceRegistries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        List<ServiceRegistry> list = this.serviceRegistries;
        synchronized (list) {
            this.isInited = false;
            this.serviceRegistries.clear();
        }
    }

    @Override
    public void registerService(ServiceRegistry service) {
        this.serviceRegistries.add(service);
    }
}

