/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.bsf.Composite;
import com.kingdee.bos.bsf.service.Configuration;
import com.kingdee.bos.bsf.service.IServiceRepositoryLoader;
import com.kingdee.bos.bsf.service.ServiceConfigException;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ServiceRepositoryLoader
implements IServiceRepositoryLoader {
    private static final Logger logger = Logger.getLogger(ServiceRepositoryLoader.class);
    private final Map<Composite, Configuration> configurations = new HashMap<Composite, Configuration>();
    private final List<Composite> composites = new ArrayList<Composite>();
    private final Set<URL> moduleURLs = new HashSet<URL>();

    @Override
    public synchronized Configuration getConfiguration(Composite composite) {
        if (composite == null) {
            return null;
        }
        return this.configurations.get(composite);
    }

    @Override
    public synchronized boolean isBind2Composite(URL url) {
        return this.moduleURLs.contains(url);
    }

    private List<Composite> innerIterate() throws BOSException {
        File[] files;
        ArrayList<Composite> composites = new ArrayList<Composite>();
        File root = Configuration.getModuleDir();
        if (!root.exists() || !root.isDirectory()) {
            throw new ServiceConfigException("BSF modules directory not exist.");
        }
        FilenameFilter xmlfilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        };
        for (File f : files = root.listFiles()) {
            URL url = Configuration.toURL(f);
            if (!f.isDirectory() || this.moduleURLs.contains(url)) continue;
            File meta = Configuration.getMetaDir(f);
            File desc = Configuration.getModuleDescFile(meta);
            if (meta.exists() && desc.exists()) {
                Composite composite;
                File[] xmls = meta.listFiles(xmlfilter);
                try {
                    composite = Configuration.getComposite(desc, false);
                }
                catch (Exception e) {
                    logger.error((Object)("can't getComposite in directory:" + f.getPath()), (Throwable)e);
                    continue;
                }
                this.configurations.put(composite, new Configuration(url, this.convert2URL(xmls)));
                composites.add(composite);
                this.moduleURLs.add(url);
                this.composites.add(composite);
                continue;
            }
            logger.warn((Object)("BSF ignore directory: can't find META-INF/module.desc in directory:" + f.getPath()));
        }
        return composites;
    }

    @Override
    public synchronized List<Composite> iterate() throws BOSException {
        this.configurations.clear();
        this.moduleURLs.clear();
        this.composites.clear();
        return this.innerIterate();
    }

    @Override
    public synchronized List<Composite> incrementalIterate() throws BOSException {
        return this.innerIterate();
    }

    @Override
    public synchronized Composite[] getComposites() {
        return this.composites.toArray(new Composite[0]);
    }

    private List<URL> convert2URL(File[] files) throws BOSException {
        ArrayList<URL> urls = new ArrayList<URL>(files.length);
        for (File f : files) {
            urls.add(Configuration.toURL(f));
        }
        return urls;
    }

    @Override
    public synchronized void remove(Composite composite) {
        Configuration config = this.configurations.remove(composite);
        if (config != null) {
            this.moduleURLs.remove(config.home);
        }
    }
}

