/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.bsf.Resolver;
import com.kingdee.bos.bsf.WorkDirectory;
import com.kingdee.bos.bsf.parsing.PathParser;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import org.apache.log4j.Logger;

class WorkDirectoryResolver
implements Resolver<WorkDirectory> {
    private static final Logger logger = Logger.getLogger(WorkDirectoryResolver.class);
    private final URL home;

    WorkDirectoryResolver(URL home) {
        this.home = home;
    }

    @Override
    public void resolve(WorkDirectory base) throws BOSException {
        ArrayList<URL> urls = new ArrayList<URL>();
        URL runtime = null;
        try {
            runtime = new URL(this.home, "tmp/");
            urls.add(runtime);
            urls.add(new URL(this.home, "classes/"));
            urls.addAll(new PathParser().expandPaths(new File(new URL(this.home, "lib/*.jar").toURI()).getAbsolutePath()));
        }
        catch (Exception e) {
            logger.error((Object)("BSF can't add classes or lib to classPath. module:" + this.home));
        }
        base.setURLs(urls.toArray(new URL[0]));
        base.setRuntime(runtime);
    }
}

