/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.type;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.asm.ClassWriter;
import com.kingdee.bos.asm.MethodVisitor;
import com.kingdee.bos.asm.Type;
import com.kingdee.bos.bsf.type.FieldInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;

public class ClassGenerator {
    private final URL runtime;

    public ClassGenerator(URL runtime) {
        this.runtime = runtime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateJavaBean(String className, FieldInfo ... fields) throws Exception {
        ClassWriter cw = new ClassWriter(0);
        cw.visit(49, 1, className, null, "java/lang/Object", null);
        for (FieldInfo ft : fields) {
            cw.visitField(2, ft.getName(), Type.getDescriptor(ft.getType()), null, null).visitEnd();
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, Type.getInternalName(Object.class), "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        for (FieldInfo ft : fields) {
            String field = ft.getName().substring(0, 1).toUpperCase() + ft.getName().substring(1);
            String methodName = "get" + field;
            mv = cw.visitMethod(1, methodName, Type.getMethodDescriptor((Type)Type.getType(ft.getType()), (Type[])new Type[0]), null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, className, ft.getName(), Type.getDescriptor(ft.getType()));
            mv.visitInsn(this.createReturn(Type.getType(ft.getType())));
            mv.visitMaxs(1, 1);
            mv.visitEnd();
            methodName = "set" + field;
            mv = cw.visitMethod(1, methodName, Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(ft.getType())}), null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(ClassGenerator.createLoad(Type.getType(ft.getType())), 1);
            mv.visitFieldInsn(181, className, ft.getName(), Type.getDescriptor(ft.getType()));
            mv.visitInsn(177);
            mv.visitMaxs(2, 2);
            mv.visitEnd();
        }
        cw.visitEnd();
        File dir = ClassGenerator.toFile(this.runtime);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File path = new File(dir, className + ".class");
        try (FileOutputStream out = new FileOutputStream(path);){
            ((OutputStream)out).write(cw.toByteArray());
        }
    }

    private static File toFile(URL url) throws BOSException {
        if (url == null) {
            return null;
        }
        try {
            return new File(url.getPath());
        }
        catch (Exception e) {
            throw new BOSException("can't convert url to file. url:" + url, (Throwable)e);
        }
    }

    public static int createLoad(Type type) {
        switch (type.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return 21;
            }
            case 6: {
                return 23;
            }
            case 8: {
                return 24;
            }
            case 7: {
                return 22;
            }
            case 9: 
            case 10: {
                return 25;
            }
        }
        throw new RuntimeException("Invalid type " + type);
    }

    public static int createArrayLoad(Type type) {
        switch (type.getSort()) {
            case 1: 
            case 3: {
                return 51;
            }
            case 2: {
                return 52;
            }
            case 4: {
                return 53;
            }
            case 5: {
                return 46;
            }
            case 6: {
                return 48;
            }
            case 8: {
                return 49;
            }
            case 7: {
                return 47;
            }
            case 9: 
            case 10: {
                return 50;
            }
        }
        throw new RuntimeException("Invalid type " + type);
    }

    private int createReturn(Type type) {
        switch (type.getSort()) {
            case 9: 
            case 10: {
                return 176;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return 172;
            }
            case 6: {
                return 174;
            }
            case 8: {
                return 175;
            }
            case 7: {
                return 173;
            }
            case 0: {
                return 177;
            }
        }
        throw new RuntimeException("Invalid type: " + type);
    }
}

