/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.type;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.asm.Type;
import com.kingdee.bos.bsf.Composite;
import com.kingdee.bos.bsf.Domain;
import com.kingdee.bos.bsf.ServiceException;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.TypeVariable;

public class TypeUtils {
    public static Class<?> getClass(java.lang.reflect.Type type, int i) {
        if (type == null) {
            return null;
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.getGenericClass((ParameterizedType)type, i);
        }
        if (type instanceof TypeVariable) {
            return TypeUtils.getClass(((TypeVariable)type).getBounds()[0], 0);
        }
        return (Class)type;
    }

    private static Class<?> getGenericClass(ParameterizedType parameterizedType, int i) {
        java.lang.reflect.Type genericClass = parameterizedType.getActualTypeArguments()[i];
        if (genericClass instanceof ParameterizedType) {
            return (Class)((ParameterizedType)genericClass).getRawType();
        }
        if (genericClass instanceof GenericArrayType) {
            return (Class)((GenericArrayType)genericClass).getGenericComponentType();
        }
        if (genericClass instanceof TypeVariable) {
            return TypeUtils.getClass(((TypeVariable)genericClass).getBounds()[0], 0);
        }
        return (Class)genericClass;
    }

    public static Class<?> getClass(java.lang.reflect.Type type) {
        if (type == null) {
            return null;
        }
        if (type.getClass() == Class.class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.getClass(((ParameterizedType)type).getRawType());
        }
        return Object.class;
    }

    public static Object newInstance(Composite composite, String typeDesc) throws BOSException {
        try {
            return TypeUtils.getClass(composite, typeDesc).newInstance();
        }
        catch (Exception e) {
            throw new ServiceException("new instance error. class:" + typeDesc, e);
        }
    }

    public static Class<?> getClass(Composite composite, String typeDesc) throws BOSException {
        try {
            return Domain.getInstance(composite).getClass(TypeUtils.getClassName(typeDesc));
        }
        catch (Exception e) {
            throw new ServiceException("get class error. class:" + typeDesc, e);
        }
    }

    public static String getClassName(String typeDesc) {
        return Type.getType((String)typeDesc).getClassName();
    }

    public static String getTypeDesc(Class<?> clazz) {
        return Type.getDescriptor(clazz);
    }
}

