<%@ include file="/html/common/init.jsp"%>
<%@ page import="com.kingdee.bos.bsf.*"%>
<%@ page import="com.kingdee.bos.bsf.manage.*"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<html">
<head>
<link rel="stylesheet" type="text/css" href="bsf.css" />
<title>BSF View</title>
</head>

<body>
<div id="modules">
	<h2>modules</h2>
	<%
		List<CompositeDesc> composites = ServiceViewFactory.getRemoteInstance()
				.listComposites();
		
		java.util.Collections.sort(composites);
		String module = null;
		for (CompositeDesc composite : composites)
		{
			if(!composite.getModule().equals(module))
			{
				if(module != null)
				{
					out.println("</ul>");
					out.println("</div>");
				}
				module = composite.getModule();
				out.println("<h3>" + module + "</h3>");
				out.println("<div>");
				out.println("<ul>");
			}
			out.print("<li><a href=\"modules.jsp?module=" + module + "&version=" + composite.getVersion() + "\">");
			out.print(composite.getVersion());
			out.println("</a></li>");
		}
		if(composites.size() > 0)
		{
			out.println("</ul>");
			out.println("</div>");
		}
		out.flush();
	%>
</div>
<div id="services">
	<h2>services</h2>
	<div>
		<ul>
			<%
			String m = request.getParameter("module");
			String v = request.getParameter("version");
			v=org.apache.commons.lang3.StringEscapeUtils.escapeHtml4(v);
			m=org.apache.commons.lang3.StringEscapeUtils.escapeHtml4(m);
			if (m != null && v != null)
			{
				List<ServiceDesc> services = ServiceViewFactory.getRemoteInstance()
					.listServices(new CompositeDesc(m, v));
				java.util.Collections.sort(services);
				for (ServiceDesc s : services)
				{
					out.print("<li><a href=\"modules.jsp?module=" + m
						+ "&version=" + v + "&service=" + s.getName()
						+ "&interface=" + s.getInterface() + "\">");
					out.print(s.getName());
					out.print("</a> - ");
					out.print(s.getInterface());
					out.print("<p>");
					out.print(s.getDescription());
					out.print("</p></li>");
				}
				out.flush();
			}
			%>
		</ul>
	</div>
</div>
<div id="operations">
	<h2>operations</h2>
	<div>
		<%
		String s = request.getParameter("service");
		String i = request.getParameter("interface");
		s=org.apache.commons.lang3.StringEscapeUtils.escapeHtml4(s);
		i=org.apache.commons.lang3.StringEscapeUtils.escapeHtml4(i);
		if (m != null && v != null && s != null)
		{
			List<OperationDesc> operations = ServiceViewFactory
					.getRemoteInstance().listOperations(
							new ServiceDesc(new CompositeDesc(m, v), s, i));
			java.util.Collections.sort(operations);
			TypeRef type;
			for (OperationDesc o : operations)
			{
				out.print("<li><em>");
				out.print(o.getName());
				out.print("</em><hr/>");
				out.println("<p>");
				out.print(o.getDescription());
				out.print("</p><div>");
				out.print("parameters:");
				out.print("<ol>");
				for (ParamDesc p : o.getParams())
				{
					type = p.getType();
					out.print("<li>");
					out.print(p.getName());
					out.print(" - ");
					if (type.isLink())
					{
						out.print("<a href=\"type.jsp?module="
								+ m + "&version=" + v + "&clazz="
								+ type.getName() + "\">");
						out.println(type);
						out.println("</a>");
					} else
					{
						out.println(type);
					}
					out.print("<p>");
					out.print(p.getDescription());
					out.print("</p></li>");
				}
				out.print("</ol>");
				out.print("</div><div>");
				out.print("return:");
				type = o.getResult().getType();
				if(type.isLink())
				{
					out.print("<a href=\"type.jsp?module="
							+ m + "&version=" + v + "&clazz="
							+ type.getName() + "\">");
					out.println(type);
					out.println("</a>");
				
				} else
				{
					out.print(type);
				}
				out.print("<p>");
				out.print(o.getResult().getDescription());
				out.print("</p></div></li>");
			}
			out.flush();
		}
		%>
	</div>
</div>
</body>
</html>