<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/html/common/init.jsp"%>
<%@ page import="com.kingdee.bos.bsf.*"%>
<%@ page import="com.kingdee.bos.bsf.manage.*"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<html">
<head>
<title>BSF Type</title>
</head>

<body>
<%
			String m = request.getParameter("module");
			String v = request.getParameter("version");
			String c = request.getParameter("clazz");
			m=org.apache.commons.lang3.StringEscapeUtils.escapeHtml4(m);
			v=org.apache.commons.lang3.StringEscapeUtils.escapeHtml4(v);
			c=org.apache.commons.lang3.StringEscapeUtils.escapeHtml4(c);
			
			if (m != null && v != null && c != null)
			{
				TypeDesc type = ServiceViewFactory
						.getRemoteInstance().getType(new TypeRef(new CompositeDesc(m, v), c, true));
				out.println("<h2>" + type.getName() + "</h2>");
				if(type.getParent() != null)
				{
					if(type.getParent().isLink())
					{
						out.print("extends <a href=\"type.jsp?module="
								+ m + "&version=" + v + "&clazz="
								+ type.getParent().getName() + "\">");
					out.print(type.getParent().getName());
					out.print("</a>");
					} else
					{
						out.print("extends ");
						out.print(type.getParent().getName());
					}
		
				}
				
				if(type.getElement() != null)
				{
					if(type.getElement().isLink())
					{
						out.print("element <a href=\"type.jsp?module="
								+ m + "&version=" + v + "&clazz="
								+ type.getElement().getName() + "\">");
					out.print(type.getElement().getName());
					out.print("</a>");
					} else
					{
						out.print("element ");
						out.print(type.getElement().getName());
					}
		
				}
				
				out.print("<p><a href=\"#json\">[json]</a></p>");
				
				out.println("<hr/>");
				out.print("<div>");
				out.print("<p>");
				out.print(type.getDescription());
				out.print("</p><h4>fields:</h4>");
				out.print("<ul>");
				for(FieldDesc f : type.getFields())
				{
					out.print("<li>");
					out.print(f.getName());
					out.print(" - ");
					if (f.getType().isLink())
					{
						out.print("<a href=\"type.jsp?module="
								+ m + "&version=" + v + "&clazz="
								+ f.getType().getName() + "\">");
						out.println(f.getType());
						out.println("</a>");
					} else
					{
						out.println(f.getType());
					}
					out.print("<p>");
					out.print(f.getDescription());
					out.print("</p></li>");
				}
				out.print("</ul>");
				out.print("</div>");
				
				out.print("<hr/>");
				out.print("<h2>json like:</h2>");
				out.print("<div id=\"json\">");
				String json = type.toJson();
				if(json != null)
				{
					String[] jsons = json.split("\\$");
					StringBuffer sb = new StringBuffer();
					for(int i = 0; i + 2 < jsons.length;i=i + 2)
					{
						sb.append(jsons[i]);
						sb.append("<a href=\"type.jsp?module="
								+ m + "&version=" + v + "&clazz=");
						sb.append(jsons[i + 1]);
						sb.append("\">");
						sb.append(jsons[i + 1]);
						sb.append("</a>");
					}
					sb.append(jsons[jsons.length - 1]);
					out.print(sb);
				}

				out.print("</div>");
			
				out.flush();
			}
%>
</body>
</html>