/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bigobjectcache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

class FileCacheObject {
    private String filename;
    private long timestamp;
    private boolean writeError;
    private boolean removed = false;

    public FileCacheObject(String filename, Serializable object) {
        this.filename = filename;
        this.write(object);
        this.timestamp = System.currentTimeMillis();
    }

    private void write(Serializable object) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.filename);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(object);
            oos.flush();
            fos.flush();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            this.writeError = true;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.writeError = true;
            throw new RuntimeException(e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable getObject() {
        if (this.writeError || this.removed) {
            return null;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.filename);
            ObjectInputStream ois = new ObjectInputStream(fis);
            Object o = ois.readObject();
            Serializable serializable = (Serializable)o;
            return serializable;
        }
        catch (IOException e) {
            e.printStackTrace();
            Serializable serializable = null;
            return serializable;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            Serializable serializable = null;
            return serializable;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void remove() {
        File file = new File(this.filename);
        if (file.exists()) {
            file.delete();
        }
        this.removed = true;
    }

    public long getTimestamp() {
        return this.timestamp;
    }
}

