/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.cache;

import com.kingdee.bos.cache.CacheException;
import com.kingdee.bos.cache.CacheReference;
import com.kingdee.bos.cache.LockHandle;
import com.kingdee.bos.cache.impl.util;
import java.util.Vector;

public class MultiLock
implements LockHandle {
    protected long timeout;
    protected long startTime;
    protected Vector handles = new Vector();
    protected Object releaseTrace = util.traceRelease("MultiLock");

    public MultiLock(long _timeout) {
        this.timeout = _timeout;
        this.startTime = System.currentTimeMillis();
    }

    public synchronized long getTimeout() {
        long t = this.timeout - (System.currentTimeMillis() - this.startTime);
        if (t < 0L) {
            t = 0L;
        }
        return t;
    }

    public void lockRead(CacheReference ref, long timeout) {
        this.lock(ref, true, timeout);
    }

    public void lockRead(CacheReference ref) {
        this.lock(ref, true, -1L);
    }

    public void lockWrite(CacheReference ref, long timeout) {
        this.lock(ref, false, timeout);
    }

    public void lockWrite(CacheReference ref) {
        this.lock(ref, false, -1L);
    }

    protected synchronized void lock(CacheReference ref, boolean read, long timeout) {
        try {
            LockHandle h = read ? (timeout < 0L ? ref.lockRead() : ref.lockRead(timeout)) : (timeout < 0L ? ref.lockWrite() : ref.lockWrite(timeout));
            this.handles.addElement(h);
        }
        catch (Throwable e) {
            this.unlock();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new CacheException("Lock failed.", e);
        }
    }

    public synchronized void addHandle(LockHandle handle) {
        this.handles.addElement(handle);
    }

    public synchronized void removeHandle(LockHandle handle) {
        this.handles.removeElement(handle);
    }

    @Override
    public synchronized void unlock() {
        for (int i = this.handles.size() - 1; i >= 0; --i) {
            try {
                ((LockHandle)this.handles.elementAt(i)).unlock();
                continue;
            }
            catch (Throwable e) {
                util.logError(e);
            }
        }
        this.handles.removeAllElements();
    }

    protected void finalize() throws Throwable {
        if (this.handles.size() > 0) {
            util.logError(this.releaseTrace.toString());
        }
    }
}

