/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.cache.impl;

import com.kingdee.bos.cache.CacheException;
import com.kingdee.bos.cache.LockHandle;
import com.kingdee.bos.cache.impl.MultiAccess;
import com.kingdee.bos.cache.impl.ObjectBase;
import com.kingdee.bos.cache.impl.util;
import java.util.Vector;

class Accessor {
    static final int READ = 1;
    static final int WRITE = 2;
    static final int DESTROY = 3;
    ObjectBase object;
    private Vector locks = new Vector();
    private Vector readRequests = new Vector();
    private Vector writeRequests = new Vector();
    private Vector destroyRequests = new Vector();

    static String toString(int type) {
        switch (type) {
            case 3: {
                return "DESTROY";
            }
            case 2: {
                return "WRITE";
            }
        }
        return "READ";
    }

    Accessor(ObjectBase _object) {
        this.object = _object;
    }

    private static CacheException willDestroy() {
        return new CacheException("Object will be destroyed by another.");
    }

    private static CacheException lockTimeout() {
        return new CacheException("Lock timeout.");
    }

    synchronized int getLockCount() {
        return this.locks.size();
    }

    synchronized int getRequestCount() {
        return this.readRequests.size() + this.writeRequests.size() + this.destroyRequests.size();
    }

    void lock(MultiAccess handle, Object owner, int type) {
        try {
            switch (type) {
                case 1: {
                    handle.addLockHandle(this.lockRead(owner, handle.getTimeout()));
                    break;
                }
                case 2: {
                    handle.addLockHandle(this.lockWrite(owner, handle.getTimeout()));
                    break;
                }
                case 3: {
                    handle.addLockHandle(this.lockDestroy(owner, handle.getTimeout()));
                    break;
                }
                default: {
                    throw new Error("Unknown lock type (" + type + ").");
                }
            }
        }
        catch (Throwable e) {
            handle.unlock();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new CacheException("Lock failed.", e);
        }
    }

    synchronized LockHandle lockRead(Object owner, long timeout) throws Throwable {
        long t0 = System.currentTimeMillis();
        Handle request = new Handle(owner, 1);
        this.readRequests.addElement(request);
        try {
            while (true) {
                if (this.destroyRequests.size() > 0) {
                    throw Accessor.willDestroy();
                }
                boolean canLock = this.writeRequests.size() == 0;
                for (int i = 0; canLock && i < this.locks.size(); ++i) {
                    Handle h = (Handle)this.locks.elementAt(i);
                    if (h.owner.equals(request.owner)) continue;
                    if (h.type == 3) {
                        throw Accessor.willDestroy();
                    }
                    if (h.type != 2) continue;
                    canLock = false;
                }
                if (canLock) {
                    this.locks.addElement(request);
                    Handle i = request;
                    return i;
                }
                if (timeout <= 0L) {
                    throw Accessor.lockTimeout();
                }
                this.wait(timeout);
                long t1 = System.currentTimeMillis();
                timeout -= t1 - t0;
                t0 = t1;
            }
        }
        finally {
            this.readRequests.removeElement(request);
        }
    }

    synchronized LockHandle lockWrite(Object owner, long timeout) throws Throwable {
        long t0 = System.currentTimeMillis();
        Handle request = new Handle(owner, 2);
        this.writeRequests.addElement(request);
        try {
            while (true) {
                if (this.destroyRequests.size() > 0) {
                    throw Accessor.willDestroy();
                }
                boolean canLock = this.writeRequests.elementAt(0) == request;
                for (int i = 0; canLock && i < this.locks.size(); ++i) {
                    Handle h = (Handle)this.locks.elementAt(i);
                    if (h.owner.equals(request.owner)) continue;
                    if (h.type == 3) {
                        throw Accessor.willDestroy();
                    }
                    canLock = false;
                }
                if (canLock) {
                    this.locks.addElement(request);
                    Handle i = request;
                    return i;
                }
                if (timeout <= 0L) {
                    throw Accessor.lockTimeout();
                }
                this.wait(timeout);
                long t1 = System.currentTimeMillis();
                timeout -= t1 - t0;
                t0 = t1;
            }
        }
        finally {
            this.writeRequests.removeElement(request);
        }
    }

    synchronized LockHandle lockDestroy(Object owner, long timeout) throws Throwable {
        long t0 = System.currentTimeMillis();
        Handle request = new Handle(owner, 3);
        this.destroyRequests.addElement(request);
        try {
            while (true) {
                if (this.destroyRequests.elementAt(0) != request) {
                    throw Accessor.willDestroy();
                }
                this.notifyAll();
                boolean canLock = true;
                for (int i = 0; canLock && i < this.locks.size(); ++i) {
                    Handle h = (Handle)this.locks.elementAt(i);
                    if (h.owner.equals(request.owner)) continue;
                    if (h.type == 3) {
                        throw Accessor.willDestroy();
                    }
                    canLock = false;
                }
                if (canLock) {
                    this.locks.addElement(request);
                    Handle i = request;
                    return i;
                }
                if (timeout <= 0L) {
                    throw Accessor.lockTimeout();
                }
                this.wait(timeout);
                long t1 = System.currentTimeMillis();
                timeout -= t1 - t0;
                t0 = t1;
            }
        }
        finally {
            this.destroyRequests.removeElement(request);
        }
    }

    protected synchronized void unlockHandle(Object handle) {
        if (!this.locks.remove(handle)) {
            Error e = new Error("lock handle not match.");
            util.logError(e);
            throw e;
        }
        this.notifyAll();
    }

    private class Handle
    implements LockHandle {
        Object owner;
        int type;

        Handle(Object _owner, int _type) {
            this.owner = _owner;
            this.type = _type;
            util.logInfo(this.toString("LOCK"));
        }

        @Override
        public void unlock() {
            Accessor.this.unlockHandle(this);
            util.logInfo(this.toString("UNLOCK"));
        }

        String toString(String name) {
            return this.owner.toString() + " " + name + " " + Accessor.toString(this.type) + " " + Accessor.this.object.toString();
        }
    }
}

