/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.cache.impl;

import com.kingdee.bos.cache.LockHandle;
import com.kingdee.bos.cache.impl.DistributeService;
import com.kingdee.bos.cache.impl.ObjectBase;
import com.kingdee.bos.cache.impl.Region;
import com.kingdee.bos.cache.impl.RemoteValue;
import com.kingdee.bos.cache.impl.ServiceImpl;
import com.kingdee.bos.cache.impl.Value;
import com.kingdee.bos.cache.impl.util;

class DistributeFunctions {
    DistributeFunctions() {
    }

    static void enabled(ObjectBase obj, boolean b) {
        DistributeService[] services = ServiceImpl.getRemoteServices();
        for (int i = 0; i < services.length; ++i) {
            try {
                services[i].enabled(obj.getPath(), b);
                continue;
            }
            catch (Throwable e) {
                util.logError(e);
            }
        }
    }

    static void invalidate(ObjectBase obj) {
        DistributeService[] services = ServiceImpl.getRemoteServices();
        for (int i = 0; i < services.length; ++i) {
            try {
                services[i].invalidate(obj.getPath());
                continue;
            }
            catch (Throwable e) {
                util.logError(e);
            }
        }
    }

    static void destroy(ObjectBase obj) {
        DistributeService[] services = ServiceImpl.getRemoteServices();
        for (int i = 0; i < services.length; ++i) {
            try {
                services[i].destroy(obj.getPath());
                continue;
            }
            catch (Throwable e) {
                util.logError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Value search(Region region, Object name) {
        Value value = new Value(name, region, null);
        LockHandle h = value.lock(1);
        try {
            DistributeService[] services = ServiceImpl.getRemoteServices();
            RemoteValue x = null;
            for (int i = 0; i < services.length; ++i) {
                try {
                    x = services[i].search(value.getPath());
                    if (x == null) continue;
                    break;
                }
                catch (Throwable e) {
                    util.logError(e);
                }
            }
            if (x == null) {
                Value value2 = null;
                return value2;
            }
            value.setRemoteValue(x);
            Value value3 = value;
            return value3;
        }
        finally {
            h.unlock();
        }
    }

    static void prepareUpdate(Value value, Object args) throws Exception {
        DistributeService[] services = ServiceImpl.getRemoteServices();
        for (int i = 0; i < services.length; ++i) {
            services[i].prepareUpdate(value.getPath(), args);
        }
    }

    static void finishUpdate(Value value) {
        DistributeService[] services = ServiceImpl.getRemoteServices();
        for (int i = 0; i < services.length; ++i) {
            try {
                services[i].finishUpdate(value.getPath());
                continue;
            }
            catch (Throwable e) {
                util.logError(e);
            }
        }
    }

    static void cancelUpdate(Value value) {
        DistributeService[] services = ServiceImpl.getRemoteServices();
        for (int i = 0; i < services.length; ++i) {
            try {
                services[i].cancelUpdate(value.getPath());
                continue;
            }
            catch (Throwable e) {
                util.logError(e);
            }
        }
    }

    static boolean remoteLoad(Value value) {
        DistributeService[] services = ServiceImpl.getRemoteServices();
        for (int i = 0; i < services.length; ++i) {
            try {
                value.setValue(services[i].remoteLoad(value.getPath()));
                return true;
            }
            catch (Throwable e) {
                if (e instanceof NullPointerException) continue;
                util.logError(e);
                continue;
            }
        }
        return false;
    }

    static void reload(Value value) {
        DistributeService[] services = ServiceImpl.getRemoteServices();
        for (int i = 0; i < services.length; ++i) {
            try {
                services[i].reload(value.getPath());
                continue;
            }
            catch (Throwable e) {
                util.logError(e);
            }
        }
    }

    static void replace(Value value, Object x) {
        DistributeService[] services = ServiceImpl.getRemoteServices();
        for (int i = 0; i < services.length; ++i) {
            try {
                services[i].replace(value.getPath(), x);
                continue;
            }
            catch (Throwable e) {
                util.logError(e);
            }
        }
    }

    static void setWeak(Value value, boolean b) {
        DistributeService[] services = ServiceImpl.getRemoteServices();
        for (int i = 0; i < services.length; ++i) {
            try {
                services[i].setWeak(value.getPath(), b);
                continue;
            }
            catch (Throwable e) {
                util.logError(e);
            }
        }
    }

    static void discard(Value value) {
        DistributeService[] services = ServiceImpl.getRemoteServices();
        for (int i = 0; i < services.length; ++i) {
            try {
                services[i].discard(value.getPath());
                continue;
            }
            catch (Throwable e) {
                util.logError(e);
            }
        }
    }
}

