/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.cache.impl;

import com.kingdee.bos.cache.Attributes;
import com.kingdee.bos.cache.CacheEvent;
import com.kingdee.bos.cache.CacheEventListener;
import com.kingdee.bos.cache.CacheException;
import com.kingdee.bos.cache.CacheReference;
import com.kingdee.bos.cache.LockHandle;
import com.kingdee.bos.cache.ObjectMonitor;
import com.kingdee.bos.cache.impl.Accessor;
import com.kingdee.bos.cache.impl.AllAttributes;
import com.kingdee.bos.cache.impl.CurrentAttributes;
import com.kingdee.bos.cache.impl.DistributeFunctions;
import com.kingdee.bos.cache.impl.DistributeServiceImpl;
import com.kingdee.bos.cache.impl.MultiAccess;
import com.kingdee.bos.cache.impl.ObjectPath;
import com.kingdee.bos.cache.impl.ObjectReference;
import com.kingdee.bos.cache.impl.Region;
import com.kingdee.bos.cache.impl.RegionReference;
import com.kingdee.bos.cache.impl.ServiceImpl;
import com.kingdee.bos.cache.impl.Value;
import com.kingdee.bos.cache.impl.util;
import java.util.Vector;

class ObjectBase {
    protected final Region parent;
    protected Attributes attrs;
    protected final Object name;
    protected final ObjectPath path;
    protected final Accessor accessor;
    final AllAttributes allAttrs;
    final CurrentAttributes curAttrs;
    protected final long createTime;
    protected volatile long idleTime;
    protected final Vector<CacheEventListener> listeners;
    protected boolean disabled = false;
    protected boolean invalid = false;
    protected boolean destroyed = false;
    boolean distributed;

    ObjectBase(Object _name, Region _parent, Attributes _attrs) {
        this.name = _name;
        this.parent = _parent;
        this.attrs = _attrs;
        this.path = new ObjectPath(this, this.getClass().equals(Region.class));
        this.accessor = new Accessor(this);
        this.allAttrs = new AllAttributes(this);
        this.curAttrs = new CurrentAttributes(this);
        this.idleTime = this.createTime = System.currentTimeMillis();
        this.listeners = new Vector();
        this.distributed = this.parent != null ? this.parent.distributed : true;
    }

    void addEventListener(CacheEventListener l) {
        this.listeners.addElement(l);
    }

    void removeEventListener(CacheEventListener l) {
        this.listeners.removeElement(l);
    }

    void notifyEvent(int id) {
        CacheReference ref = this.getReference();
        try {
            this.notifyEvent(new CacheEvent(id, ref));
        }
        catch (Throwable e) {
            util.logError(e);
        }
        ref.release();
    }

    void notifyEvent(CacheEvent e) {
        CacheEventListener[] lsns = this.listeners.toArray(new CacheEventListener[0]);
        for (int i = 0; i < lsns.length; ++i) {
            try {
                lsns[i].actionPerformed(e);
                continue;
            }
            catch (Throwable ex) {
                util.logError(ex);
            }
        }
    }

    void resetIdle() {
        this.idleTime = System.currentTimeMillis();
        if (this.parent != null) {
            this.parent.resetIdle();
        }
    }

    long getLiveTime() {
        return System.currentTimeMillis() - this.createTime;
    }

    long getIdleTime() {
        if (this.accessor.getLockCount() > 0 || this.accessor.getRequestCount() > 0) {
            this.resetIdle();
        }
        return System.currentTimeMillis() - this.idleTime;
    }

    synchronized void lock(MultiAccess handle, Object owner, int type, boolean distribute) {
        this.resetIdle();
        this.accessor.lock(handle, owner, type);
        if (this.parent != null) {
            this.parent.lock(handle, owner, 1, false);
        }
        if (distribute && type != 1) {
            DistributeServiceImpl.distributeLock(handle, this.path, owner, type);
        }
    }

    synchronized LockHandle lock(Object owner, int type, long timeout, boolean distribute) {
        MultiAccess handle = new MultiAccess(timeout);
        this.lock(handle, owner, type, distribute);
        return handle;
    }

    LockHandle lock(int type, long timeout) {
        return this.lock(Thread.currentThread(), type, timeout, this.isDistributed());
    }

    LockHandle lock(int type) {
        return this.lock(type, this.allAttrs.getLong(2, 2000L));
    }

    ObjectPath getPath() {
        return this.path;
    }

    Object getName() {
        return this.name;
    }

    boolean isDisabled() {
        if (this.disabled) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.isDisabled();
        }
        return false;
    }

    boolean isInvalid() {
        if (this.invalid) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.isInvalid();
        }
        return false;
    }

    boolean isDestroyed() {
        if (this.destroyed) {
            return true;
        }
        if (this.parent != null) {
            this.parent.isDestroyed();
        }
        return false;
    }

    boolean isRegion() {
        return this instanceof Region;
    }

    boolean isDistributed() {
        return this.distributed && this.allAttrs.getBoolean(9);
    }

    synchronized void enabled(boolean b) {
        if (this.disabled == !b) {
            return;
        }
        LockHandle h = this.lock(2);
        try {
            this.enabledThis(b);
            if (this.isDistributed()) {
                DistributeFunctions.enabled(this, b);
            }
        }
        finally {
            h.unlock();
        }
        if (b) {
            this.notifyEvent(4);
        } else {
            this.notifyEvent(5);
        }
    }

    synchronized void enabledThis(boolean b) {
        this.disabled = !b;
    }

    synchronized void invalidate() {
        if (this.invalid) {
            return;
        }
        LockHandle h = this.lock(2);
        try {
            this.invalidateThis();
            if (this.isDistributed()) {
                DistributeFunctions.invalidate(this);
            }
        }
        finally {
            h.unlock();
        }
        this.notifyEvent(6);
    }

    synchronized void invalidateThis() {
        this.invalid = true;
    }

    synchronized void destroyThis() {
        this.destroy(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void destroy(boolean distributed, boolean block) {
        this.notifyEvent(8);
        LockHandle h = null;
        try {
            this.destroyed = true;
            ServiceImpl.removeObject(this.getPath());
            if (this.parent != null) {
                this.parent.removeChild(this.name);
            }
            this.finalDestroy();
            if (distributed && this.isDistributed()) {
                DistributeFunctions.destroy(this);
            }
        }
        finally {
            if (h != null) {
                h.unlock();
            }
        }
        this.notifyEvent(7);
    }

    synchronized void finalDestroy() {
    }

    synchronized void checkAccess() {
        if (this.isDisabled()) {
            throw new CacheException("Object is disabled.");
        }
        if (this.isInvalid()) {
            throw new CacheException("Object is invalid.");
        }
        if (this.isDestroyed()) {
            throw new CacheException("Object is destroyed.");
        }
    }

    synchronized ObjectMonitor getMonitor() {
        return (ObjectMonitor)this.allAttrs.get(1);
    }

    CacheReference getReference() {
        if (this.isRegion()) {
            return new RegionReference((Region)this);
        }
        return new ObjectReference((Value)this);
    }

    void monitorCheck() {
        ObjectMonitor monitor;
        if (!this.isDestroyed() && (monitor = this.getMonitor()) != null) {
            CacheReference ref = this.getReference();
            try {
                monitor.check(ref);
            }
            catch (Throwable e) {
                util.logError(e);
            }
            ref.release();
        }
    }

    Object getTreeAttribute(int index) {
        return this.allAttrs.get(index);
    }

    Object getCurrentAttribute(int index) {
        return this.curAttrs.get(index);
    }

    public String toString() {
        if (this.getPath() != null) {
            return this.getPath().toString();
        }
        return "";
    }
}

