/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.cache.impl;

import com.kingdee.bos.cache.Attributes;
import com.kingdee.bos.cache.CacheException;
import com.kingdee.bos.cache.CacheObject;
import com.kingdee.bos.cache.CacheReference;
import com.kingdee.bos.cache.CacheRegion;
import com.kingdee.bos.cache.LockHandle;
import com.kingdee.bos.cache.ObjectAttributes;
import com.kingdee.bos.cache.RegionAttributes;
import com.kingdee.bos.cache.impl.DistributeFunctions;
import com.kingdee.bos.cache.impl.ObjectBase;
import com.kingdee.bos.cache.impl.ObjectReference;
import com.kingdee.bos.cache.impl.RegionReference;
import com.kingdee.bos.cache.impl.ServiceImpl;
import com.kingdee.bos.cache.impl.Value;
import com.kingdee.bos.cache.impl.util;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

class Region
extends ObjectBase {
    Attributes objectDefaultAttrs;
    private final HashMap all = new HashMap();
    private final HashMap regions = new HashMap();
    private final LRUCapacityMap objects;

    Region(Object name, Region parent, RegionAttributes attrs, ObjectAttributes _objectDefaultAttrs) {
        super(name, parent, attrs);
        this.objectDefaultAttrs = _objectDefaultAttrs;
        this.objects = new LRUCapacityMap(attrs.getInt(24, 1024));
        ServiceImpl.addObject(this);
    }

    synchronized RegionAttributes getAttributes() {
        return (RegionAttributes)this.attrs;
    }

    synchronized void setAttributes(RegionAttributes _attrs) {
        this.checkAccess();
        this.attrs = _attrs;
    }

    synchronized ObjectAttributes getDefaultObjectAttributes() {
        return (ObjectAttributes)this.objectDefaultAttrs;
    }

    synchronized void setDefaultObjectAttributes(ObjectAttributes attrs) {
        this.checkAccess();
        this.objectDefaultAttrs = attrs;
    }

    synchronized CacheRegion createSubRegion(Object name, RegionAttributes attrs, ObjectAttributes defaultObjectAttrs) {
        this.checkAccess();
        this.checkExists(name);
        Region region = new Region(name, this, attrs, defaultObjectAttrs);
        this.all.put(name, region);
        this.regions.put(name, region);
        return new RegionReference(region);
    }

    synchronized CacheRegion getRegion(Object name) {
        Region region = (Region)this.regions.get(name);
        if (region == null) {
            return null;
        }
        return new RegionReference(region);
    }

    synchronized CacheRegion[] getRegions() {
        Object[] rs0 = this.regions.values().toArray();
        CacheRegion[] rs = new CacheRegion[rs0.length];
        for (int i = 0; i < rs0.length; ++i) {
            rs[i] = new RegionReference((Region)rs0[i]);
        }
        return rs;
    }

    synchronized int getRegionCount() {
        return this.regions.size();
    }

    synchronized boolean exists(Object name) {
        return this.all.containsKey(name);
    }

    synchronized CacheReference get(Object name) {
        ObjectBase obj = (ObjectBase)this.all.get(name);
        if (obj == null) {
            return null;
        }
        if (obj.isRegion()) {
            return new RegionReference((Region)obj);
        }
        return new ObjectReference((Value)obj);
    }

    public synchronized CacheObject[] getObjects() {
        Object[] objs = this.objects.values().toArray();
        CacheObject[] os = new CacheObject[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            os[i] = new ObjectReference((Value)objs[i]);
        }
        return os;
    }

    public synchronized int getObjectCount() {
        return this.objects.size();
    }

    public synchronized Object[] childrenNames() {
        return this.all.keySet().toArray();
    }

    public synchronized int childCount() {
        return this.all.size();
    }

    public synchronized Object getObjectValue(Object name) {
        Value obj = this.searchObject(name);
        if (obj == null) {
            return null;
        }
        return obj.directGet();
    }

    void checkExists(Object name) {
        if (this.exists(name)) {
            throw new CacheException("Object name '" + name + "'already exists.");
        }
    }

    synchronized Value createObject(Object name, ObjectAttributes attrs) {
        this.checkAccess();
        this.checkExists(name);
        Value v = new Value(name, this, attrs);
        ServiceImpl.addObject(v);
        this.all.put(name, v);
        this.objects.put(name, v);
        return v;
    }

    synchronized void preLoad(Object name, ObjectAttributes attrs) {
        this.createObject(name, attrs).preLoad();
    }

    synchronized void delayLoad(Object name, ObjectAttributes attrs) {
        this.createObject(name, attrs);
    }

    synchronized CacheObject load(Object name, ObjectAttributes attrs) {
        return this.createObject(name, attrs).load();
    }

    synchronized void putObject(Object name, Object value, ObjectAttributes attrs) {
        this.createObject(name, attrs).setValue(value);
    }

    public synchronized CacheObject getObject(Object name) {
        Value v = this.searchObject(name);
        if (v == null) {
            return null;
        }
        return (CacheObject)v.getReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Value searchObject(Object name) {
        Value v = (Value)this.objects.get(name);
        if (v == null) {
            LockHandle h = this.lock(1);
            try {
                v = DistributeFunctions.search(this, name);
                if (v != null) {
                    ServiceImpl.addObject(v);
                    this.all.put(name, v);
                    this.objects.put(name, v);
                }
            }
            finally {
                h.unlock();
            }
        }
        return v;
    }

    synchronized void removeChild(Object name) {
        this.all.remove(name);
        this.regions.remove(name);
        this.objects.remove(name);
        if (this.all.size() == 0 && !this.isDestroyed() && this.allAttrs.getBoolean(11)) {
            this.destroy(false, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized void destroy(boolean distributed, boolean block) {
        LockHandle hLock = null;
        if (block) {
            hLock = this.lock(3);
        }
        try {
            super.destroy(distributed, false);
            distributed &= !this.isDistributed();
            Object[] objs = this.all.values().toArray();
            for (int i = 0; i < objs.length; ++i) {
                try {
                    ((ObjectBase)objs[i]).destroy(distributed, false);
                    continue;
                }
                catch (Throwable e) {
                    util.logError(e);
                }
            }
        }
        finally {
            if (hLock != null) {
                hLock.unlock();
            }
        }
    }

    CacheRegion getRegion(Object[] names) {
        return this.getRegion(names, 0);
    }

    protected synchronized CacheRegion getRegion(Object[] names, int off) {
        Region region = (Region)this.regions.get(names[off]);
        if (region == null) {
            return null;
        }
        if (off == names.length - 1) {
            return (CacheRegion)region.getReference();
        }
        return region.getRegion(names, off + 1);
    }

    CacheObject getObject(Object[] names) {
        return this.getObject(names, 0);
    }

    protected synchronized CacheObject getObject(Object[] names, int off) {
        if (off == names.length - 1) {
            return this.getObject(names[off]);
        }
        Region region = (Region)this.regions.get(names[off]);
        if (region == null) {
            return null;
        }
        return region.getObject(names, off + 1);
    }

    static class LRUCapacityMap
    extends LinkedHashMap<Object, Value> {
        private static final long serialVersionUID = -6942465092342162085L;
        private static final float DEFATULT_LOAD_FACTOR = 0.75f;
        private final int capacity;

        LRUCapacityMap() {
            super(11, 0.75f, true);
            this.capacity = 1024;
        }

        LRUCapacityMap(int capacity) {
            super(11, 0.75f, true);
            this.capacity = capacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Object, Value> eldest) {
            int upper = this.size() - this.capacity;
            if (upper > 0) {
                eldest.getValue().attrs.setLong(6, 1000L);
            }
            return false;
        }
    }
}

