/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.cache.impl;

import com.kingdee.bos.cache.Attributes;
import com.kingdee.bos.cache.CacheException;
import com.kingdee.bos.cache.CacheLoader;
import com.kingdee.bos.cache.CacheObject;
import com.kingdee.bos.cache.Destroyable;
import com.kingdee.bos.cache.DistributeUpdate;
import com.kingdee.bos.cache.LockHandle;
import com.kingdee.bos.cache.ObjectAttributes;
import com.kingdee.bos.cache.Updateable;
import com.kingdee.bos.cache.impl.DistributeFunctions;
import com.kingdee.bos.cache.impl.MultiAccess;
import com.kingdee.bos.cache.impl.ObjectBase;
import com.kingdee.bos.cache.impl.ObjectReference;
import com.kingdee.bos.cache.impl.Region;
import com.kingdee.bos.cache.impl.RemoteValue;
import com.kingdee.bos.cache.impl.util;
import java.lang.ref.WeakReference;

class Value
extends ObjectBase {
    protected Object refOrObj = null;
    protected boolean weak;
    protected boolean loading = false;
    protected boolean discarded = false;
    boolean remote = false;
    protected Loader loader = new Loader(this);

    Value(Object name, Region parent, Attributes attrs) {
        super(name, parent, attrs);
        this.weak = this.allAttrs.getBoolean(22);
    }

    synchronized void setValue(Object value) {
        this.finalDestroy();
        this.refOrObj = value == null ? null : (this.weak ? new WeakReference<Object>(value) : value);
        this.resetIdle();
    }

    synchronized Object getValue() {
        this.resetIdle();
        if (this.refOrObj == null) {
            return null;
        }
        if (this.weak) {
            return ((WeakReference)this.refOrObj).get();
        }
        return this.refOrObj;
    }

    synchronized void setWeak(boolean b) {
        if (this.weak == b) {
            return;
        }
        LockHandle h = this.lock(2);
        try {
            this.setWeakThis(b);
            if (this.isDistributed()) {
                DistributeFunctions.setWeak(this, b);
            }
        }
        finally {
            h.unlock();
        }
    }

    synchronized void setWeakThis(boolean b) {
        Object obj = this.getValue();
        this.weak = b;
        this.refOrObj = b ? new WeakReference<Object>(obj) : obj;
    }

    synchronized boolean isWeak() {
        return this.weak;
    }

    boolean isRemote() {
        return this.remote;
    }

    synchronized boolean isAvailable() {
        return this.getValue() != null;
    }

    synchronized boolean isLoading() {
        return this.loading;
    }

    synchronized boolean isDiscarded() {
        return this.discarded;
    }

    public synchronized ObjectAttributes getAttributes() {
        return (ObjectAttributes)this.attrs;
    }

    public synchronized void setAttributes(ObjectAttributes _attrs) {
        this.attrs = _attrs;
    }

    synchronized Object directGet() {
        if (!this.allAttrs.getBoolean(21, true)) {
            throw new CacheException("Can't get object's value directly.");
        }
        return this.get();
    }

    public synchronized Object get() {
        this.checkAccess();
        return this.innerGet();
    }

    synchronized Object innerGet() {
        if (this.isLoading()) {
            this.waitThis();
        } else if (!this.isAvailable()) {
            this.loader.load();
        }
        return this.getValue();
    }

    synchronized void waitThis() {
        try {
            this.wait();
        }
        catch (Throwable e) {
            throw new CacheException(e.getMessage(), e);
        }
    }

    synchronized void replace(Object value) {
        LockHandle h = this.lock(2);
        try {
            this.checkAccess();
            this.replaceThis(value);
            if (this.isDistributed()) {
                DistributeFunctions.replace(this, value);
            }
        }
        finally {
            h.unlock();
        }
    }

    synchronized void replaceThis(Object value) {
        if (this.isLoading()) {
            this.waitThis();
        }
        this.setValue(value);
        this.discarded = false;
    }

    synchronized void reload() {
        LockHandle h = this.lock(2);
        try {
            this.checkAccess();
            this.reloadThis();
            if (this.isDistributed()) {
                DistributeFunctions.reload(this);
            }
        }
        finally {
            h.unlock();
        }
    }

    synchronized void reloadThis() {
        this.finalDestroy();
        this.loader.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void update(Object args) throws Exception {
        this.checkAccess();
        LockHandle h = this.lock(2);
        boolean distributed = this.isDistributed();
        try {
            try {
                this.prepareUpdate(args, distributed);
                this.finishUpdate(distributed);
            }
            catch (Exception e) {
                this.cancelUpdate(distributed);
                throw e;
            }
        }
        finally {
            h.unlock();
        }
    }

    synchronized void discard() {
        if (this.isDiscarded()) {
            return;
        }
        LockHandle h = this.lock(2);
        try {
            this.discardThis();
            if (this.isDistributed()) {
                DistributeFunctions.discard(this);
            }
        }
        finally {
            h.unlock();
        }
    }

    synchronized void discardThis() {
        this.discarded = true;
        this.finalDestroy();
    }

    synchronized void preLoad() {
        util.startThread(this.loader);
    }

    synchronized CacheObject load() {
        this.loader.load();
        return new ObjectReference(this);
    }

    @Override
    synchronized void finalDestroy() {
        try {
            Object v = this.getValue();
            if (v != null && v instanceof Destroyable) {
                ((Destroyable)v).destroy();
            }
            this.refOrObj = null;
        }
        catch (Throwable e) {
            util.logError(e);
        }
        super.finalDestroy();
    }

    CacheLoader getLoader() {
        if (this.curAttrs.getBoolean(4)) {
            return (CacheLoader)this.allAttrs.get(3);
        }
        return (CacheLoader)this.curAttrs.get(3);
    }

    synchronized void prepareUpdate(Object args, boolean distributed) throws Exception {
        Object v = this.getValue();
        if (v == null) {
            return;
        }
        if (v instanceof DistributeUpdate) {
            ((DistributeUpdate)v).prepareUpdate(args);
        } else if (v instanceof Updateable) {
            ((Updateable)v).update(args);
        } else {
            throw new CacheException("Object must implements Updateable or DistributeUpdate.");
        }
        if (distributed) {
            DistributeFunctions.prepareUpdate(this, args);
        }
    }

    synchronized void cancelUpdate(boolean distributed) {
        try {
            Object v = this.getValue();
            if (v == null) {
                return;
            }
            if (v instanceof DistributeUpdate) {
                ((DistributeUpdate)v).cancelUpdate();
            }
        }
        catch (Throwable e) {
            util.logError(e);
        }
        if (distributed) {
            DistributeFunctions.cancelUpdate(this);
        }
    }

    synchronized void finishUpdate(boolean distributed) {
        try {
            Object v = this.getValue();
            if (v == null) {
                return;
            }
            if (v instanceof DistributeUpdate) {
                ((DistributeUpdate)v).finishUpdate();
            }
        }
        catch (Throwable e) {
            util.logError(e);
        }
        if (distributed) {
            DistributeFunctions.finishUpdate(this);
        }
    }

    @Override
    synchronized void lock(MultiAccess handle, Object owner, int type, boolean distribute) {
        super.lock(handle, owner, type, distribute);
        if (this.isWeak()) {
            handle.addObjectHandle(this.getValue());
        }
    }

    synchronized RemoteValue getRemoteValue() {
        RemoteValue x = new RemoteValue();
        x.disabled = this.disabled;
        x.invalid = this.invalid;
        x.weak = this.weak;
        x.value = this.innerGet();
        return x;
    }

    synchronized void setRemoteValue(RemoteValue x) {
        this.remote = true;
        this.disabled = x.disabled;
        this.invalid = x.invalid;
        this.weak = x.weak;
        this.setValue(x.value);
    }

    @Override
    boolean isDistributed() {
        return this.remote || super.isDistributed();
    }

    private class Loader
    implements Runnable {
        Value parent;

        Loader(Value _parent) {
            this.parent = _parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void load() {
            util.assertThat(!Value.this.isLoading(), "isLoading");
            Value value = this.parent;
            synchronized (value) {
                this.parent.loading = true;
            }
            try {
                if (Value.this.isRemote() && DistributeFunctions.remoteLoad(this.parent)) {
                    return;
                }
                CacheLoader loader = Value.this.getLoader();
                if (loader == null) {
                    throw new CacheException("no CacheLoader available.");
                }
                Object v = loader.load(Value.this.allAttrs.get(23));
                Value.this.setValue(v);
            }
            finally {
                value = this.parent;
                synchronized (value) {
                    this.parent.loading = false;
                    this.parent.discarded = false;
                    this.parent.notifyAll();
                }
            }
        }

        @Override
        public void run() {
            try {
                this.load();
            }
            catch (Throwable e) {
                util.logError(e);
            }
        }
    }
}

