/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.jcache;

import com.kingdee.bos.jcache.CacheAttributes;
import com.kingdee.bos.jcache.Region;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Attributes
implements CacheAttributes,
Serializable {
    protected final HashMap map = new HashMap();
    protected final Attributes[] parents;

    public static Attributes create(Region parent, Attributes attrs) {
        if (parent == null) {
            if (attrs == null) {
                return new Attributes();
            }
            return new Attributes(attrs);
        }
        if (attrs == null) {
            return new Attributes(parent.attributes());
        }
        return new Attributes(new Attributes[]{parent.attributes(), attrs});
    }

    public Attributes() {
        this(new Attributes[0]);
    }

    public Attributes(Attributes parent) {
        this(new Attributes[]{parent});
    }

    public Attributes(Attributes[] parents) {
        this.parents = parents == null ? new Attributes[]{} : parents;
    }

    public synchronized boolean exists(Object key) {
        if (this.map.containsKey(key)) {
            return true;
        }
        for (int i = 0; i < this.parents.length; ++i) {
            if (!this.parents[i].exists(key)) continue;
            return true;
        }
        return false;
    }

    public synchronized Object getValue(Object key, Object defaultValue) {
        if (this.map.containsKey(key)) {
            return this.map.get(key);
        }
        for (int i = 0; i < this.parents.length; ++i) {
            if (!this.parents[i].exists(key)) continue;
            return this.parents[i].getValue(key);
        }
        return defaultValue;
    }

    public Object getValue(Object key) {
        return this.getValue(key, null);
    }

    public synchronized void setValue(Object key, Object value) {
        this.map.put(key, value);
    }

    public synchronized void remove(Object key) {
        this.map.remove(key);
    }

    public String getString(Object key, String defaultValue) {
        return (String)this.getValue(key, defaultValue);
    }

    public String getString(Object key) {
        return this.getString(key, null);
    }

    public void setString(Object key, String value) {
        this.setValue(key, value);
    }

    public boolean getBoolean(Object key, boolean defaultValue) {
        return (Boolean)this.getValue(key, defaultValue);
    }

    public boolean getBoolean(Object key) {
        return this.getBoolean(key, false);
    }

    public void setBoolean(Object key, boolean value) {
        this.setValue(key, value);
    }

    public int getInt(Object key, int defaultValue) {
        return (Integer)this.getValue(key, defaultValue);
    }

    public int getInt(Object key) {
        return this.getInt(key, 0);
    }

    public void setInt(Object key, int value) {
        this.setValue(key, value);
    }

    public long getLong(Object key, long defaultValue) {
        return ((Long)this.getValue(key, defaultValue)).intValue();
    }

    public long getLong(Object key) {
        return this.getLong(key, 0L);
    }

    public void setLong(Object key, long value) {
        this.setValue(key, value);
    }

    public Map getOwnerAttributes() {
        return (Map)this.map.clone();
    }

    public Map getAttributes() {
        Map rte = (Map)this.map.clone();
        for (int i = 0; i < this.parents.length; ++i) {
            rte.putAll(this.parents[i].getAttributes());
        }
        return rte;
    }
}

