/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.jcache.impl;

import com.kingdee.bos.jcache.Attributes;
import com.kingdee.bos.jcache.CacheException;
import com.kingdee.bos.jcache.CacheRef;
import com.kingdee.bos.jcache.Event;
import com.kingdee.bos.jcache.Path;
import com.kingdee.bos.jcache.Region;
import com.kingdee.bos.jcache.impl.CacheEngineImpl;
import com.kingdee.bos.jcache.impl.EventManager;
import com.kingdee.bos.jcache.impl.RegionImpl;
import java.lang.ref.ReferenceQueue;

abstract class CacheRefImpl
extends EventManager
implements CacheRef {
    final Path path;
    final RegionImpl parent;
    final Attributes attrs;
    final Object monitor;
    final ReferenceQueue refQueue;
    volatile boolean valid = true;

    protected CacheRefImpl(Object name, boolean isRegion, RegionImpl parent, Attributes initAttrs) {
        this.path = new Path(parent == null ? null : parent.path, name, isRegion);
        this.parent = parent;
        this.attrs = Attributes.create(parent, initAttrs);
        this.monitor = parent == null ? new Object() : parent.monitor;
        this.refQueue = parent == null ? new ReferenceQueue() : parent.refQueue;
    }

    protected abstract void finalDestroy();

    final void destroy() {
        if (this.valid) {
            this.valid = false;
            this.fireEvent(new Event(102, this, null));
            this.finalDestroy();
        }
    }

    abstract boolean checkLive();

    @Override
    public Object monitor() {
        return this.monitor;
    }

    @Override
    public boolean isRegion() {
        return this.path.isRegion();
    }

    @Override
    public Object name() {
        return this.path.getName();
    }

    @Override
    public Region parent() {
        return this.parent;
    }

    @Override
    public Path path() {
        return this.path;
    }

    @Override
    public Attributes attributes() {
        return this.attrs;
    }

    @Override
    public void fireEvent(Event event) {
        this.processEvent(event);
    }

    @Override
    boolean processEvent(Event event) {
        if (CacheEngineImpl.eventManager.processEvent(event)) {
            return true;
        }
        if (this.parent != null && this.parent.processEvent(event)) {
            return true;
        }
        return super.processEvent(event);
    }

    void invalidate() {
        this.valid = false;
    }

    @Override
    public boolean isValid() {
        return this.valid && (this.parent == null || this.parent.isValid());
    }

    @Override
    public void validate() {
        if (!this.valid) {
            throw new CacheException(107, "invalid object(" + this.toString() + ")");
        }
        if (this.parent != null) {
            this.parent.validate();
        }
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean equals(Object x) {
        if (x == null) {
            return false;
        }
        if (x instanceof CacheRefImpl) {
            return ((CacheRefImpl)x).path.equals(this.path);
        }
        return false;
    }

    public String toString() {
        return this.path.toString();
    }

    @Override
    public void notifyChange() {
        if (this.isValid() && this.attrs.getBoolean("distributed", false)) {
            this.fireEvent(new Event(301, this, this.path));
            CacheEngineImpl.distributeNotifyChange(this.path);
        }
    }
}

