/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.jcache.impl;

import com.kingdee.bos.jcache.Attributes;
import com.kingdee.bos.jcache.CacheException;
import com.kingdee.bos.jcache.CacheLoader;
import com.kingdee.bos.jcache.Event;
import com.kingdee.bos.jcache.ObjectHandler;
import com.kingdee.bos.jcache.ObjectRef;
import com.kingdee.bos.jcache.impl.CacheEngineImpl;
import com.kingdee.bos.jcache.impl.CacheRefImpl;
import com.kingdee.bos.jcache.impl.RegionImpl;
import org.apache.log4j.Logger;

class ObjectRefImpl
extends CacheRefImpl
implements ObjectRef {
    private static final Logger logger = Logger.getLogger(ObjectRefImpl.class);
    private static long timestamp = 1L;
    private ObjectHandler handler;
    private long loadExceptionTime = 0L;
    private Throwable loadException = null;
    private boolean firstUsed = false;

    private static synchronized long time() {
        return timestamp++;
    }

    ObjectRefImpl(Object name, RegionImpl parent, Attributes initAttrs) {
        super(name, false, parent, initAttrs);
        Class handlerClass = (Class)this.attrs.getValue("objectHandlerClass", Attributes.DEFAULT_OBJECT_HANDLER);
        try {
            this.handler = (ObjectHandler)handlerClass.newInstance();
            this.handler.init(this);
        }
        catch (Throwable e) {
            throw CacheException.create(e);
        }
    }

    @Override
    protected void finalDestroy() {
        this.discard(false, false);
    }

    @Override
    public synchronized Object getCurrentValue() {
        return this.handler.get();
    }

    private CacheLoader getLoader(boolean canBeNull) {
        CacheLoader loader = (CacheLoader)this.attrs.getValue("cacheLoader");
        if (loader == null && !canBeNull) {
            throw new CacheException(108, this.toString() + " no CacheLoader.");
        }
        return loader;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Object get() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkChange(Object oldVal) {
        Object val = this.getCurrentValue();
        if (val != oldVal) {
            this.fireEvent(new Event(201, this, new Object[]{oldVal, val}));
        }
        if (oldVal != null) {
            this.unload(oldVal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Object val) {
        Object oldVal;
        if (val == null) {
            throw new CacheException(109, "null value.");
        }
        ObjectRefImpl objectRefImpl = this;
        synchronized (objectRefImpl) {
            this.validate();
            this.handler.enterUse();
            try {
                oldVal = this.handler.get();
                this.handler.set(val);
                this.firstUsed = true;
            }
            finally {
                this.handler.leaveUse();
            }
        }
        this.checkChange(oldVal);
        this.notifyChange();
    }

    public void discard() {
        this.discard(true);
    }

    @Override
    public void discard(boolean notifyChange) {
        this.discard(notifyChange, true);
    }

    private void unload(Object val) {
        CacheLoader loader;
        if (val != null && this.attrs.getBoolean("needUnload", false) && (loader = this.getLoader(true)) != null) {
            final ObjectRefImpl ref = this;
            final Object unloadVal = val;
            CacheEngineImpl.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)(ref.toString() + " unload object."));
                        }
                        loader.unload(ref, unloadVal);
                    }
                    catch (Throwable e) {
                        logger.error((Object)(ref.toString() + " unload error."), e);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discard(boolean notifyChange, boolean fireEvent) {
        Object val;
        ObjectRefImpl objectRefImpl = this;
        synchronized (objectRefImpl) {
            val = this.handler.get();
            this.handler.set(null);
        }
        if (val != null && fireEvent) {
            this.fireEvent(new Event(201, this, new Object[]{val, null}));
        }
        if (val != null) {
            this.unload(val);
        }
        if (notifyChange) {
            this.notifyChange();
        }
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.handler.isNull();
    }

    @Override
    public synchronized boolean isWeak() {
        return this.handler.isWeak();
    }

    @Override
    public synchronized long getLiveTime() {
        return this.handler.getLiveTime();
    }

    @Override
    public synchronized long getIdleTime() {
        return this.handler.getIdleTime();
    }

    public synchronized void setWeak() {
        Object val = this.getCurrentValue();
        if (val != null) {
            this.handler = new ObjectHandler.Weak();
            this.handler.init(this);
            this.handler.set(val);
        }
    }

    @Override
    synchronized boolean checkLive() {
        if (!this.isValid()) {
            return false;
        }
        Object oldVal = this.handler.get();
        this.handler.check(this);
        Object newVal = this.handler.get();
        if (oldVal != newVal) {
            this.fireEvent(new Event(201, this, new Object[]{oldVal, newVal}));
        }
        return !this.firstUsed || newVal != null || !this.attrs.getBoolean("autoDelete", true);
    }
}

