/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.jcache.jgroups;

import com.kingdee.bos.jcache.CacheEngine;
import com.kingdee.bos.jcache.DistributeMonitor;
import com.kingdee.bos.jcache.DistributeNotifier;
import java.io.Serializable;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.View;

public class JGroupsNotifier
extends Thread
implements DistributeNotifier {
    private static final Logger logger = Logger.getLogger(JGroupsNotifier.class);
    public static final String DEFAULT_PROPS = "UDP(down_thread=false;mcast_send_buf_size=640000;mcast_port=45566;discard_incompatible_packets=true;ucast_recv_buf_size=20000000;mcast_addr=228.10.10.10;up_thread=false;loopback=false;mcast_recv_buf_size=25000000;max_bundle_size=64000;max_bundle_timeout=30;use_incoming_packet_handler=true;use_outgoing_packet_handler=false;ucast_send_buf_size=640000;tos=16;enable_bundling=true;ip_ttl=2):PING(timeout=2000;down_thread=false;num_initial_members=3;up_thread=false):MERGE2(max_interval=10000;down_thread=false;min_interval=5000;up_thread=false):FD(timeout=2000;max_tries=3;down_thread=false;up_thread=false):VERIFY_SUSPECT(timeout=1500;down_thread=false;up_thread=false):pbcast.NAKACK(max_xmit_size=60000;down_thread=false;use_mcast_xmit=false;gc_lag=0;discard_delivered_msgs=true;up_thread=false;retransmit_timeout=100,200,300,600,1200,2400,4800):UNICAST(timeout=300,600,1200,2400,3600;down_thread=false;up_thread=false):pbcast.STABLE(stability_delay=1000;desired_avg_gossip=50000;max_bytes=400000;down_thread=false;up_thread=false):VIEW_SYNC(down_thread=false;avg_send_interval=60000;up_thread=false):pbcast.GMS(print_local_addr=true;join_timeout=3000;down_thread=false;join_retry_timeout=2000;up_thread=false;shun=true):FC(max_credits=2000000;down_thread=false;up_thread=false;min_threshold=0.10):FRAG2(frag_size=60000;down_thread=false;up_thread=false):pbcast.STATE_TRANSFER(down_thread=false;up_thread=false)";
    public static final String DEFAULT_CHANNEL_NAME = "Kingdee-DistributeCache";
    JChannel channel = null;
    DistributeMonitor monitor = null;
    String id = null;
    String serverName = null;
    final String channelName;

    private static void turnOffLogger(String name) {
        Logger.getLogger((String)name).setLevel(Level.OFF);
    }

    public JGroupsNotifier() throws Exception {
        this(CacheEngine.cacheAttributes.getString("jgroupsProtocolStack", "UDP:PING:FD:STABLE:NAKACK:UNICAST:FRAG:FLUSH:GMS:VIEW_ENFORCER:STATE_TRANSFER:QUEUE"), CacheEngine.cacheAttributes.getString("notifierChannel", "Kingdee-Cache"));
    }

    public JGroupsNotifier(String props, String channel_name) throws Exception {
        super(channel_name);
        this.channel = new JChannel(props);
        this.channelName = channel_name;
        this.setDaemon(true);
    }

    public String getIdentifier() {
        return this.id;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public String getChannelName() {
        return this.channelName;
    }

    @Override
    public void open(DistributeMonitor monitor) throws Exception {
        this.monitor = monitor;
        this.channel.connect(this.channelName);
        this.serverName = this.channel.getLocalAddress().toString();
        this.id = this.serverName + "/" + this.channelName;
        this.start();
    }

    @Override
    public void notifiyEvent(Object event) throws Exception {
        this.channel.send(null, null, (Serializable)new Object[]{this.id, event});
    }

    @Override
    public void close() {
        this.channel.disconnect();
        this.channel.close();
    }

    public void receive(Message msg) {
        block5: {
            try {
                Object x = msg.getObject();
                Object[] de = null;
                try {
                    de = (Object[])x;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (de != null && de.length == 2 && !de[0].equals(this.id)) {
                    this.monitor.onEvent(de[1]);
                }
            }
            catch (Throwable e) {
                if (!logger.isDebugEnabled()) break block5;
                logger.debug((Object)e, e);
            }
        }
    }

    public void viewAccepted(View new_view) {
        Object[] ar = new_view.getMembers().toArray();
        String[] names = new String[ar.length];
        for (int i = 0; i < ar.length; ++i) {
            names[i] = ar[i].toString();
        }
        this.monitor.onServerView(names);
    }

    @Override
    public void run() {
        while (this.channel.isConnected() && this.channel.isOpen()) {
            try {
                Object x = this.channel.receive(0L);
                if (x == null) continue;
                if (x instanceof View) {
                    this.viewAccepted((View)x);
                    continue;
                }
                if (!(x instanceof Message)) continue;
                this.receive((Message)x);
            }
            catch (Throwable e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)e, e);
            }
        }
    }

    public static void initDistributeCache() throws Exception {
        new Init().start();
    }

    static {
        JGroupsNotifier.turnOffLogger("org.jgroups.protocols.NAKACK");
        JGroupsNotifier.turnOffLogger("org.jgroups.protocols.STABLE");
        JGroupsNotifier.turnOffLogger("org.jgroups.blocks.RequestCorrelator");
        JGroupsNotifier.turnOffLogger("org.jgroups.protocols.UDP");
        JGroupsNotifier.turnOffLogger("org.jgroups.protocols.QUEUE");
        JGroupsNotifier.turnOffLogger("org.jgroups.blocks.GroupRequest");
        JGroupsNotifier.turnOffLogger("org.jgroups.protocols.PingWaiter");
        JGroupsNotifier.turnOffLogger("org.jgroups.protocols.PingSender");
        JGroupsNotifier.turnOffLogger("org.jgroups.protocols.FD");
        JGroupsNotifier.turnOffLogger("org.jgroups.protocols.GMS");
        JGroupsNotifier.turnOffLogger("org.jgroups.protocols.ClientGmsImpl");
        JGroupsNotifier.turnOffLogger("org.jgroups.conf.ClassConfigurator");
        JGroupsNotifier.turnOffLogger("org.jgroups.util.ThreadPool");
        JGroupsNotifier.turnOffLogger("org.jgroups.protocols.AUTOCONF");
        JGroupsNotifier.turnOffLogger("org.jgroups.stack.NakReceiverWindow");
        JGroupsNotifier.turnOffLogger("org.jgroups.Message");
        JGroupsNotifier.turnOffLogger("org.jgroups.protocols.PING");
        JGroupsNotifier.turnOffLogger("org.jgroups.util.ReusableThread");
        JGroupsNotifier.turnOffLogger("org.jgroups.protocols.UNICAST");
        JGroupsNotifier.turnOffLogger("org.jgroups.protocols.FLUSH");
        JGroupsNotifier.turnOffLogger("org.jgroups.protocols.ParticipantGmsImpl");
        JGroupsNotifier.turnOffLogger("org.jgroups.protocols.FRAG");
        JGroupsNotifier.turnOffLogger("org.jgroups.stack.AckMcastReceiverWindow");
        JGroupsNotifier.turnOffLogger("org.jgroups.stack.AckMcastSenderWindow");
        JGroupsNotifier.turnOffLogger("org.jgroups.stack.AckReceiverWindow");
        JGroupsNotifier.turnOffLogger("org.jgroups.protocols.CoordGmsImpl");
        JGroupsNotifier.turnOffLogger("org.jgroups.stack.AckSenderWindow");
    }

    private static class Init
    extends Thread {
        Init() {
            super("JGroups-Distribute-Init");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                CacheEngine.initDistributeNotifier(new JGroupsNotifier());
            }
            catch (Throwable e) {
                logger.error((Object)e, e);
            }
        }
    }
}

