/*
 * Decompiled with CFR 0.152.
 */
package com.tool.classfile;

import com.tool.classfile.CodeException;
import com.tool.classfile.ConstantPool;

public class ByteCodeReader {
    public ConstantPool pool = null;
    private final byte[] bytes;
    private int current_pc = 0;

    public ByteCodeReader(byte[] data) {
        this.bytes = data;
    }

    public int current_pc() {
        return this.current_pc;
    }

    public boolean eof() {
        return this.current_pc >= this.bytes.length;
    }

    public int readu1() {
        return this.readByte() & 0xFF;
    }

    public int readu2() {
        return this.readu1() << 8 | this.readu1();
    }

    public int readu4() {
        return this.readu1() << 24 | this.readu1() << 16 | this.readu1() << 8 | this.readu1();
    }

    public int readShort() {
        return (short)this.readu2();
    }

    public int readByte() {
        CodeException.assertThat(this.current_pc < this.bytes.length);
        return this.bytes[this.current_pc++];
    }

    public int readInt() {
        return this.readu4();
    }

    public long readLong() {
        return ((long)this.readInt() & 0xFFFFFFFFL) << 32 | (long)this.readu4();
    }

    public float readFloat() {
        return Float.intBitsToFloat(this.readu4());
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public int read() {
        if (this.eof()) {
            return -1;
        }
        return this.bytes[this.current_pc++] & 0xFF;
    }

    public int read(byte[] b, int off, int len) {
        if (len > this.bytes.length - this.current_pc) {
            len = this.bytes.length - this.current_pc;
        }
        System.arraycopy(this.bytes, this.current_pc, b, off, len);
        this.current_pc += len;
        return len;
    }

    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    public byte[] readBytes(int len) {
        byte[] b = new byte[len];
        int len1 = this.read(b);
        CodeException.assertThat(len == len1);
        return b;
    }
}

