/*
 * Decompiled with CFR 0.152.
 */
package com.tool.classfile;

import com.tool.classfile.ByteCodeWriter;
import com.tool.classfile.Reference;

public class Utf8
extends Reference {
    public final String value;

    public Utf8(String _value) {
        super(1);
        this.value = _value;
    }

    protected int refHashCode() {
        return this.value.hashCode();
    }

    protected boolean refEquals(Reference ref) {
        return this.value.equals(((Utf8)ref).value);
    }

    public byte[] toByteArray() {
        return Utf8.toUtf8(this.value);
    }

    public String toString() {
        return this.value;
    }

    public static byte[] toUtf8(String s) {
        ByteCodeWriter out = new ByteCodeWriter();
        int i = 0;
        while (i < s.length()) {
            int c = s.charAt(i) & 0xFFFF;
            if (c >= 1 && c <= 127) {
                out.writeu1(c);
            } else if (c == 0 || c >= 128 && c < 2047) {
                out.writeu1(0xC0 | c >> 6 & 0x1F);
                out.writeu1(0x80 | c & 0x3F);
            } else {
                out.writeu1(0xE0 | c >> 12 & 0xF);
                out.writeu1(0x80 | c >> 6 & 0x3F);
                out.writeu1(0x80 | c & 0x3F);
            }
            ++i;
        }
        return out.toByteArray();
    }

    public static String parseUtf8(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            int b2;
            int b1;
            if (((b1 = bytes[i++] & 0xFF) & 0x80) == 0) {
                sb.append((char)b1);
                continue;
            }
            if ((b1 & 0xE0) == 192) {
                b2 = bytes[i++] & 0xFF;
                sb.append((char)(((b1 & 0x1F) << 6) + (b2 & 0x3F)));
                continue;
            }
            b2 = bytes[i++] & 0xFF;
            int b3 = bytes[i++] & 0xFF;
            sb.append((char)(((b1 & 0xF) << 12) + ((b2 & 0x3F) << 6) + (b3 & 0x3F)));
        }
        return sb.toString();
    }
}

