/*
 * Decompiled with CFR 0.152.
 */
package com.tool.classfile;

import com.tool.classfile.CodeException;
import com.tool.classfile.FieldDefinition;
import com.tool.classfile.FieldRef;
import com.tool.classfile.MethodDefinition;
import com.tool.classfile.MethodRef;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Vector;

public class sc {
    public static final String CODE = "Code";
    public static final String CONSTANTVALUE = "ConstantValue";
    public static final String EXCEPTIONS = "Exceptions";
    public static final String SOURCEFILE = "SourceFile";
    public static final String SOURCEDIR = "SourceDir";
    public static final String LINENUMBERTABLE = "LineNumberTable";
    public static final String LOCALVARIABLETABLE = "LocalVariableTable";
    public static final String DEPRECATED = "Deprecated";
    public static final String INNERCLASSES = "InnerClasses";
    public static final String SYNTHETIC = "Synthetic";
    public static final String CONSTRUCTOR = "<init>";
    public static final String CONSTRUCTOR_DEFAULT = "()V";
    public static final String CLASS_INIT = "<clinit>";
    public static final String AND = "&&";
    public static final String OR = "||";
    public static final String NOT = "!";
    public static final String BITAND = "&";
    public static final String BITOR = "|";
    public static final String BITXOR = "^";
    public static final String BITNOT = "~";
    public static final String BIT_OPER = "&|^";
    public static final String ADD = "+";
    public static final String SUB = "-";
    public static final String MUL = "*";
    public static final String DIV = "/";
    public static final String MOD = "%";
    public static final String MATH_OPER = "+-*/%";
    public static final String LSHIFT = "<<";
    public static final String RSHIFT = ">>";
    public static final String LRSHIFT = ">>>";
    public static final String GT = ">";
    public static final String GE = ">=";
    public static final String LT = "<";
    public static final String LE = "<=";
    public static final String NE = "!=";
    public static final String EQ = "==";
    public static final String NUMBER = "N";
    public static final String ARRAY = "[";
    public static final String BOOL = "Z";
    public static final String BYTE = "B";
    public static final String CHAR = "C";
    public static final String SHORT = "S";
    public static final String INT = "I";
    public static final String LONG = "J";
    public static final String FLOAT = "F";
    public static final String DOUBLE = "D";
    public static final String VOID = "V";
    public static final String STRING = "Ljava/lang/String;";
    public static final String CLASS = "Ljava/lang/Class;";
    public static final String OBJECT = "Ljava/lang/Object;";
    public static final String C_STRING = "java/lang/String";
    public static final String C_CLASS = "java/lang/Class";
    public static final String C_OBJECT = "java/lang/Object";
    public static final String VALUE = "VALUE";
    public static final int INVOKE_VIRTUAL = 0;
    public static final int INVOKE_SPECIAL = 1;
    public static final int INVOKE_INTERFACE = 2;
    public static final MethodRef OBJECT_CONSTRUCTOR_METHOD = new MethodRef("java/lang/Object", "<init>", "()V");
    public static final String class_Object = "java/lang/Object";
    public static final String type_Object = "Ljava/lang/Object;";
    public static final String class_Class = "java/lang/Class";
    public static final String type_Class = "Ljava/lang/Class;";
    public static final String class_String = "java/lang/String";
    public static final String type_String = "Ljava/lang/String;";
    public static final String class_Exception = "java/lang/Exception";
    public static final String type_Exception = "Ljava/lang/Exception;";
    public static final String class_Boolean = "java/lang/Boolean";
    public static final String class_Character = "java/lang/Character";
    public static final String class_Byte = "java/lang/Byte";
    public static final String class_Short = "java/lang/Short";
    public static final String class_Integer = "java/lang/Integer";
    public static final String class_Long = "java/lang/Long";
    public static final String class_Float = "java/lang/Float";
    public static final String class_Double = "java/lang/Double";
    public static final String class_Number = "java/lang/Number";
    public static final String class_Void = "java/lang/Void";
    public static final String type_Boolean = "Ljava/lang/Boolean;";
    public static final String type_Charcter = "Ljava/lang/Character;";
    public static final String type_Byte = "Ljava/lang/Byte;";
    public static final String type_Short = "Ljava/lang/Short;";
    public static final String type_Integer = "Ljava/lang/Integer;";
    public static final String type_Long = "Ljava/lang/Long;";
    public static final String type_Float = "Ljava/lang/Float;";
    public static final String type_Double = "Ljava/lang/Double;";
    public static final String type_Number = "Ljava/lang/Number;";
    public static final String type_Void = "Ljava/lang/Void;";
    static /* synthetic */ Class class$java$lang$Class;

    public static final boolean isType(String fromType, String toType) {
        if ((fromType = sc.pcodeType(fromType)).equals(toType = sc.pcodeType(toType))) {
            return true;
        }
        if (sc.isVoid(fromType)) {
            return false;
        }
        if (toType.equals(VALUE)) {
            return sc.isValue(fromType);
        }
        if (fromType.equals(VALUE)) {
            return sc.isValue(toType);
        }
        if (toType.equals(NUMBER)) {
            return sc.isNumber(fromType);
        }
        if (fromType.equals(NUMBER)) {
            return sc.isNumber(toType);
        }
        if (sc.isObject(toType)) {
            return sc.isObject(fromType);
        }
        return false;
    }

    public static final void checkType(String fromType, String toType) {
        if (!sc.isType(fromType, toType)) {
            throw new CodeException("'" + fromType + "' is invalided,'" + toType + "' is required.");
        }
    }

    public static final boolean isPrimitive(String type) {
        return !sc.isObject(type);
    }

    public static final boolean isCategory1(String type) {
        return !sc.isLong(type) && !sc.isDouble(type);
    }

    public static final boolean isCategory2(String type) {
        return sc.isLong(type) || sc.isDouble(type);
    }

    public static final boolean isNumber(String type) {
        return !sc.isObject(type) && !sc.isVoid(type);
    }

    public static final boolean isArray(String type) {
        return type.charAt(0) == '[';
    }

    public static final String arrayType(String type) {
        CodeException.assertThat(sc.isArray(type));
        return type.substring(1);
    }

    public static final boolean isByte(String type) {
        return type.equals(BYTE);
    }

    public static final boolean isIntOrLong(String type) {
        return sc.isInteger(type) || sc.isLong(type);
    }

    public static final boolean isVoid(String type) {
        return type.equals(VOID);
    }

    public static final boolean isValue(String type) {
        return !sc.isVoid(type);
    }

    public static final boolean isBoolean(String type) {
        return type.equals(BOOL);
    }

    public static final boolean isChar(String type) {
        return type.equals(CHAR);
    }

    public static final boolean isShort(String type) {
        return type.equals(SHORT);
    }

    public static final boolean isInteger(String type) {
        return type.equals(INT);
    }

    public static final boolean isLong(String type) {
        return type.equals(LONG);
    }

    public static final boolean isFloat(String type) {
        return type.equals(FLOAT);
    }

    public static final boolean isDouble(String type) {
        return type.equals(DOUBLE);
    }

    public static final boolean isString(String type) {
        return type.equals("Ljava/lang/String;");
    }

    public static final boolean isObject(String type) {
        return type.length() > 1 || sc.isArray(type);
    }

    public static final String classType(String name) {
        if (name.startsWith("L") && name.endsWith(";") || name.startsWith(ARRAY) || sc.isPrimitive(name)) {
            return name;
        }
        return "L" + name.replace('.', '/') + ";";
    }

    public static final String className(Class cls) {
        if (cls.isArray() || cls.isPrimitive()) {
            return sc.classDescriptor(cls);
        }
        return cls.getName().replace('.', '/');
    }

    public static final String className(String name) {
        if (name.startsWith("L") && name.endsWith(";")) {
            return name.substring(1, name.length() - 1);
        }
        return name.replace('.', '/');
    }

    public static final String classDescriptor(String name) {
        if (name.equals("boolean")) {
            return BOOL;
        }
        if (name.equals("byte")) {
            return BYTE;
        }
        if (name.equals("char")) {
            return CHAR;
        }
        if (name.equals("short")) {
            return SHORT;
        }
        if (name.equals("int")) {
            return INT;
        }
        if (name.equals("long")) {
            return LONG;
        }
        if (name.equals("float")) {
            return FLOAT;
        }
        if (name.equals("double")) {
            return DOUBLE;
        }
        if (name.equals("void")) {
            return VOID;
        }
        if (name.endsWith("[]")) {
            return ARRAY + sc.classDescriptor(name.substring(0, name.length() - 2));
        }
        return "L" + name.replace('.', '/') + ";";
    }

    public static final String classDescriptor(Class cls) {
        if (cls.isArray()) {
            return ARRAY + sc.classDescriptor(cls.getComponentType());
        }
        if (!cls.isPrimitive()) {
            return "L" + cls.getName().replace('.', '/') + ";";
        }
        if (cls.equals(Boolean.TYPE)) {
            return BOOL;
        }
        if (cls.equals(Byte.TYPE)) {
            return BYTE;
        }
        if (cls.equals(Character.TYPE)) {
            return CHAR;
        }
        if (cls.equals(Short.TYPE)) {
            return SHORT;
        }
        if (cls.equals(Integer.TYPE)) {
            return INT;
        }
        if (cls.equals(Long.TYPE)) {
            return LONG;
        }
        if (cls.equals(Float.TYPE)) {
            return FLOAT;
        }
        if (cls.equals(Double.TYPE)) {
            return DOUBLE;
        }
        return VOID;
    }

    public static final String fieldDescriptor(Field fld) {
        return sc.classDescriptor(fld.getType());
    }

    private static String methodDescriptor(Class returnType, Class[] parameters) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        int i = 0;
        while (i < parameters.length) {
            sb.append(sc.classDescriptor(parameters[i]));
            ++i;
        }
        sb.append(")");
        sb.append(sc.classDescriptor(returnType));
        return sb.toString();
    }

    public static final String methodDescriptor(Method md) {
        return sc.methodDescriptor(md.getReturnType(), md.getParameterTypes());
    }

    public static final String constructorDesriptor(Constructor c) {
        return sc.methodDescriptor(Void.TYPE, c.getParameterTypes());
    }

    public static final String methodReturnType(String descriptor) {
        int index = descriptor.indexOf(41);
        return descriptor.substring(index + 1);
    }

    private static int nextParameter(String descriptor, int startIndex) {
        char c = descriptor.charAt(startIndex);
        switch (c) {
            case '[': {
                return sc.nextParameter(descriptor, startIndex + 1) + 1;
            }
            case ')': {
                return 0;
            }
            case 'L': {
                return descriptor.indexOf(59, startIndex) - startIndex + 1;
            }
        }
        return 1;
    }

    public static final String[] methodParameters(String descriptor) {
        int len;
        Vector<String> v = new Vector<String>();
        int index = descriptor.indexOf(40) + 1;
        while ((len = sc.nextParameter(descriptor, index)) != 0) {
            v.addElement(descriptor.substring(index, index + len));
            index += len;
        }
        Object[] ps = new String[v.size()];
        v.copyInto(ps);
        return ps;
    }

    public static final String sourceString(String s) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    sb.append("\\\\");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                case '\'': {
                    sb.append("\\'");
                    break;
                }
                case '\"': {
                    sb.append("\\\"");
                    break;
                }
                case '\n': {
                    sb.append("\\\n");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static final String javaClassName(String name) {
        if (name.startsWith(ARRAY)) {
            return sc.javaClassName(name.substring(1)) + "[]";
        }
        if ((name = sc.javaClassName0(name)).startsWith("java.lang.")) {
            name = name.substring(10);
        }
        return name;
    }

    public static final String javaClassName0(String name) {
        if (name.startsWith(ARRAY)) {
            return sc.javaClassName0(name.substring(1)) + "[]";
        }
        if (sc.isPrimitive(name)) {
            return sc.javaType(name);
        }
        if (name.startsWith("L") && name.endsWith(";")) {
            name = name.substring(1, name.length() - 1);
        }
        return name.replace('/', '.');
    }

    public static final String javaShortType(String type) {
        if (sc.isArray(type)) {
            return sc.javaShortType(sc.arrayType(type)) + "[]";
        }
        int i = (type = sc.javaType0(type)).lastIndexOf(46);
        if (i > 0) {
            type = type.substring(i + 1);
        }
        return type;
    }

    public static final String javaType(String type) {
        if (sc.isArray(type)) {
            return sc.javaType(sc.arrayType(type)) + "[]";
        }
        if ((type = sc.javaType0(type)).startsWith("java.lang.")) {
            type = type.substring(10);
        }
        return type;
    }

    public static final String javaType0(String type) {
        if (sc.isArray(type)) {
            return sc.javaType0(sc.arrayType(type)) + "[]";
        }
        if (sc.isVoid(type)) {
            return "void";
        }
        if (sc.isBoolean(type)) {
            return "boolean";
        }
        if (sc.isByte(type)) {
            return "byte";
        }
        if (sc.isChar(type)) {
            return "char";
        }
        if (sc.isShort(type)) {
            return "short";
        }
        if (sc.isInteger(type)) {
            return "int";
        }
        if (sc.isLong(type)) {
            return "long";
        }
        if (sc.isFloat(type)) {
            return "float";
        }
        if (sc.isDouble(type)) {
            return "double";
        }
        if (type.equals(ARRAY)) {
            return "array";
        }
        if (type.equals(NUMBER)) {
            return "number";
        }
        if (type.startsWith("L") && type.endsWith(";")) {
            type = type.substring(1, type.length() - 1);
        }
        type = type.replace('/', '.');
        return type;
    }

    public static final Class javaClass(String type) throws ClassNotFoundException {
        if (sc.isArray(type)) {
            int dims = 0;
            int i = 0;
            while (i < type.length()) {
                if (type.charAt(i) != '[') break;
                ++i;
                ++dims;
            }
            int[] dim = new int[dims];
            return Array.newInstance(sc.javaClass(type.substring(dims)), dim).getClass();
        }
        if (sc.isObject(type)) {
            return Class.forName(sc.javaType(type));
        }
        if (sc.isBoolean(type)) {
            return Boolean.TYPE;
        }
        if (sc.isByte(type)) {
            return Byte.TYPE;
        }
        if (sc.isChar(type)) {
            return Character.TYPE;
        }
        if (sc.isShort(type)) {
            return Short.TYPE;
        }
        if (sc.isInteger(type)) {
            return Integer.TYPE;
        }
        if (sc.isLong(type)) {
            return Long.TYPE;
        }
        if (sc.isFloat(type)) {
            return Float.TYPE;
        }
        if (sc.isDouble(type)) {
            return Double.TYPE;
        }
        if (sc.isVoid(type)) {
            return Void.TYPE;
        }
        throw new ClassNotFoundException(sc.javaType(type));
    }

    private static final int getNumberLevel(String type) {
        if (sc.isBoolean(type)) {
            return 0;
        }
        if (sc.isByte(type) || sc.isChar(type) || sc.isShort(type)) {
            return 1;
        }
        if (sc.isInteger(type)) {
            return 2;
        }
        if (sc.isLong(type)) {
            return 3;
        }
        if (sc.isFloat(type)) {
            return 4;
        }
        return 5;
    }

    public static final String matchNumber(String type1, String type2) {
        int level2;
        if (type1.equals(type2)) {
            return type1;
        }
        int level1 = sc.getNumberLevel(type1);
        if (level1 > (level2 = sc.getNumberLevel(type2))) {
            return sc.matchNumber(type2, type1);
        }
        if (level1 == level2) {
            return INT;
        }
        if (level2 <= 3) {
            return type2;
        }
        if (level2 == 5) {
            return DOUBLE;
        }
        if (level1 == 3) {
            return DOUBLE;
        }
        return FLOAT;
    }

    public static final String matchBitwise(String type1, String type2) {
        if (sc.isLong(type1) || sc.isLong(type2)) {
            return LONG;
        }
        return INT;
    }

    public static final int arrayDims(String type) {
        int dims = 0;
        int i = 0;
        while (i < type.length()) {
            if (type.charAt(i) != '[') break;
            ++i;
            ++dims;
        }
        return dims;
    }

    public static final String pcodeType(String type) {
        if (sc.isBoolean(type) || sc.isByte(type) || sc.isChar(type) || sc.isShort(type) || sc.isInteger(type)) {
            return INT;
        }
        return type;
    }

    private static boolean validOperator(String operator, String category) {
        return operator.length() == 1 && category.indexOf(operator.charAt(0)) >= 0;
    }

    public static final boolean validMathOper(String operator) {
        return sc.validOperator(operator, MATH_OPER);
    }

    public static final boolean validBitOper(String operator) {
        return sc.validOperator(operator, BIT_OPER);
    }

    public static final boolean validMathOrBit(String operator) {
        return sc.validMathOper(operator) || sc.validBitOper(operator);
    }

    public static final boolean validComOper(String operator, String type) {
        if (sc.isObject(type)) {
            return operator.equals(EQ) || operator.equals(NE);
        }
        if (sc.isVoid(type)) {
            return false;
        }
        return operator.equals(EQ) || operator.equals(NE) || operator.equals(GT) || operator.equals(GE) || operator.equals(LT) || operator.equals(LE);
    }

    public static int opc_type_level(String type) {
        if (sc.isInteger(type = sc.pcodeType(type))) {
            return 0;
        }
        if (sc.isLong(type)) {
            return 1;
        }
        if (sc.isFloat(type)) {
            return 2;
        }
        if (sc.isDouble(type)) {
            return 3;
        }
        return 4;
    }

    public static int opc_math_base(String oper) {
        if (oper.equals(ADD)) {
            return 96;
        }
        if (oper.equals(SUB)) {
            return 100;
        }
        if (oper.equals(MUL)) {
            return 104;
        }
        if (oper.equals(DIV)) {
            return 108;
        }
        if (oper.equals(MOD)) {
            return 112;
        }
        if (oper.equals(BITAND)) {
            return 126;
        }
        if (oper.equals(BITOR)) {
            return 128;
        }
        if (oper.equals(BITXOR)) {
            return 130;
        }
        throw new CodeException("invalid operator '" + oper + "'");
    }

    public static final Method findMethod(Class cls, String name, String descriptor) {
        Method[] mds = cls.getMethods();
        int i = 0;
        while (i < mds.length) {
            if (mds[i].getName().equals(name) && descriptor.equals(sc.methodDescriptor(mds[i]))) {
                return mds[i];
            }
            ++i;
        }
        mds = cls.getDeclaredMethods();
        int i2 = 0;
        while (i2 < mds.length) {
            if (mds[i2].getName().equals(name) && descriptor.equals(sc.methodDescriptor(mds[i2]))) {
                return mds[i2];
            }
            ++i2;
        }
        throw new CodeException("method not found " + name + descriptor);
    }

    public static final Object[] toArray(Class type, Vector v) {
        Object[] ar = (Object[])Array.newInstance(type, v.size());
        v.copyInto(ar);
        return ar;
    }

    public static final Object[] toArray(Class type, Enumeration e) {
        Vector v = new Vector();
        while (e.hasMoreElements()) {
            v.addElement(e.nextElement());
        }
        return sc.toArray(type, v);
    }

    public static final String op_type(int c) {
        switch (c) {
            case 98: {
                return BYTE;
            }
            case 99: {
                return CHAR;
            }
            case 115: {
                return SHORT;
            }
            case 105: {
                return INT;
            }
            case 108: {
                return LONG;
            }
            case 102: {
                return FLOAT;
            }
            case 100: {
                return DOUBLE;
            }
            case 97: {
                return "Ljava/lang/Object;";
            }
            case 118: {
                return VOID;
            }
            case 120: {
                return VALUE;
            }
        }
        throw new CodeException("unknown type '" + (char)c + "'");
    }

    public static final Class getJavaClass(String name) throws Exception {
        Class<?> cls = null;
        if (name.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (name.equals("byte")) {
            return Byte.TYPE;
        }
        if (name.equals("char")) {
            return Character.TYPE;
        }
        if (name.equals("short")) {
            return Short.TYPE;
        }
        if (name.equals("int")) {
            return Integer.TYPE;
        }
        if (name.equals("long")) {
            return Long.TYPE;
        }
        if (name.equals("float")) {
            return Float.TYPE;
        }
        if (name.equals("double")) {
            return Double.TYPE;
        }
        if (name.equals("void")) {
            return Void.TYPE;
        }
        if (name.endsWith("[]")) {
            return Array.newInstance(sc.getJavaClass(name.substring(0, name.length() - 2)), 0).getClass();
        }
        try {
            cls = Class.forName("java.lang." + name);
        }
        catch (Exception _) {
            cls = Class.forName(name);
        }
        return cls;
    }

    public static final Method javaMethodByName(String fullname) throws Exception {
        int index = fullname.indexOf(40);
        String name = fullname.substring(0, index);
        fullname = fullname.substring(index + 1);
        index = name.lastIndexOf(46);
        String className = name.substring(0, index);
        String methodName = name.substring(index + 1);
        Class cls = sc.getJavaClass(className);
        fullname = fullname.substring(0, fullname.length() - 1).trim();
        Vector<Class> ps = new Vector<Class>();
        if (fullname.length() > 0) {
            fullname = fullname + ",";
            while (fullname.length() > 0) {
                index = fullname.indexOf(44);
                ps.addElement(sc.getJavaClass(fullname.substring(0, index).trim()));
                fullname = fullname.substring(index + 1).trim();
            }
        }
        Class[] args = (Class[])sc.toArray(class$java$lang$Class == null ? (class$java$lang$Class = sc.class$("java.lang.Class")) : class$java$lang$Class, ps);
        try {
            return cls.getMethod(methodName, args);
        }
        catch (Exception _) {
            return cls.getDeclaredMethod(methodName, args);
        }
    }

    public static final MethodRef javaMethod(String fullname) throws Exception {
        return new MethodRef(sc.javaMethodByName(fullname));
    }

    public static final FieldRef javaField(String fullname) throws Exception {
        int index = fullname.lastIndexOf(46);
        CodeException.assertThat(index > 0);
        String className = fullname.substring(0, index);
        String fieldName = fullname.substring(index + 1);
        Class cls = sc.getJavaClass(className);
        Field fld = null;
        try {
            fld = cls.getField(fieldName);
        }
        catch (Exception _) {
            fld = cls.getDeclaredField(fieldName);
        }
        return new FieldRef(fld);
    }

    public static final String methodShortName(MethodDefinition md) {
        int f = md.access_flags & 0xFFFFFFCF;
        StringBuffer sb = new StringBuffer();
        sb.append(Modifier.toString(f) + " " + sc.javaShortType(md.type) + " " + md.name + "(");
        int i = 0;
        while (i < md.args.length) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(sc.javaShortType(md.args[i].type) + " " + md.args[i].name);
            ++i;
        }
        sb.append(")");
        return sb.toString().trim();
    }

    public static final String methodShortName(MethodRef ref, String thisClass) {
        StringBuffer sb = new StringBuffer();
        if (thisClass != null && thisClass.equals(ref.className)) {
            sb.append("this.");
        } else {
            sb.append(sc.javaClassName(ref.className) + ".");
        }
        sb.append(ref.name + "(");
        int i = 0;
        while (i < ref.parameterTypes.length) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(sc.javaShortType(ref.parameterTypes[i]));
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public static final String methodShortName(MethodRef ref) {
        return sc.methodShortName(ref, null);
    }

    public static final String methodShortName(FieldDefinition fd) {
        int f = fd.access_flags & 0xFFFFFFCF;
        String s = Modifier.toString(f) + " " + sc.javaShortType(fd.type) + " " + fd.name;
        return s.trim();
    }

    public static final FieldRef field(Class cls, String name) {
        Field fld = null;
        try {
            fld = cls.getDeclaredField(name);
        }
        catch (Exception _) {
            // empty catch block
        }
        try {
            if (fld == null) {
                fld = cls.getField(name);
            }
            return new FieldRef(fld);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CodeException(e.getMessage() + " " + cls.getName() + "." + name);
        }
    }

    public static final MethodRef method(Class cls, String name, Class[] args) {
        Method md = null;
        try {
            md = cls.getDeclaredMethod(name, args);
        }
        catch (Exception _) {
            // empty catch block
        }
        try {
            if (md == null) {
                md = cls.getMethod(name, args);
            }
            return new MethodRef(md);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CodeException(e.getMessage());
        }
    }

    public static final MethodRef method(Class cls, String name) {
        return sc.method(cls, name, new Class[0]);
    }

    public static final MethodRef method(Class cls, String name, Class argType1) {
        Class[] argTypes = new Class[]{argType1};
        return sc.method(cls, name, argTypes);
    }

    public static final MethodRef method(Class cls, String name, Class argType1, Class argType2) {
        Class[] argTypes = new Class[]{argType1, argType2};
        return sc.method(cls, name, argTypes);
    }

    public static final MethodRef method(Class cls, String name, Class argType1, Class argType2, Class argType3) {
        Class[] argTypes = new Class[]{argType1, argType2, argType3};
        return sc.method(cls, name, argTypes);
    }

    public static final MethodRef method(Class cls, String name, Class argType1, Class argType2, Class argType3, Class argType4) {
        Class[] argTypes = new Class[]{argType1, argType2, argType3, argType4};
        return sc.method(cls, name, argTypes);
    }

    public static final MethodRef method(Class cls, String name, Class argType1, Class argType2, Class argType3, Class argType4, Class argType5) {
        Class[] argTypes = new Class[]{argType1, argType2, argType3, argType4, argType5};
        return sc.method(cls, name, argTypes);
    }

    public static final MethodRef method(Class cls, String name, Class argType1, Class argType2, Class argType3, Class argType4, Class argType5, Class argType6) {
        Class[] argTypes = new Class[]{argType1, argType2, argType3, argType4, argType5, argType6};
        return sc.method(cls, name, argTypes);
    }

    public static final MethodRef method(Class cls, String name, Class argType1, Class argType2, Class argType3, Class argType4, Class argType5, Class argType6, Class argType7) {
        Class[] argTypes = new Class[]{argType1, argType2, argType3, argType4, argType5, argType6, argType7};
        return sc.method(cls, name, argTypes);
    }

    public static final MethodRef method(Class cls, String name, Class argType1, Class argType2, Class argType3, Class argType4, Class argType5, Class argType6, Class argType7, Class argType8) {
        Class[] argTypes = new Class[]{argType1, argType2, argType3, argType4, argType5, argType6, argType7, argType8};
        return sc.method(cls, name, argTypes);
    }

    public static final MethodRef method(Class cls, String name, Class argType1, Class argType2, Class argType3, Class argType4, Class argType5, Class argType6, Class argType7, Class argType8, Class argType9) {
        Class[] argTypes = new Class[]{argType1, argType2, argType3, argType4, argType5, argType6, argType7, argType8, argType9};
        return sc.method(cls, name, argTypes);
    }

    public static final MethodRef constructor(Class cls, Class[] args) {
        Constructor md = null;
        try {
            md = cls.getDeclaredConstructor(args);
        }
        catch (Exception _) {
            // empty catch block
        }
        try {
            if (md == null) {
                md = cls.getConstructor(args);
            }
            return new MethodRef(sc.className(cls), CONSTRUCTOR, sc.descriptor(Void.TYPE, args));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CodeException(e.getMessage());
        }
    }

    public static final MethodRef constructor(Class cls) {
        return sc.constructor(cls, new Class[0]);
    }

    public static final MethodRef constructor(Class cls, Class argType1) {
        Class[] argTypes = new Class[]{argType1};
        return sc.constructor(cls, argTypes);
    }

    public static final MethodRef constructor(Class cls, Class argType1, Class argType2) {
        Class[] argTypes = new Class[]{argType1, argType2};
        return sc.constructor(cls, argTypes);
    }

    public static final MethodRef constructor(Class cls, Class argType1, Class argType2, Class argType3) {
        Class[] argTypes = new Class[]{argType1, argType2, argType3};
        return sc.constructor(cls, argTypes);
    }

    public static final MethodRef constructor(Class cls, Class argType1, Class argType2, Class argType3, Class argType4) {
        Class[] argTypes = new Class[]{argType1, argType2, argType3, argType4};
        return sc.constructor(cls, argTypes);
    }

    public static final MethodRef constructor(Class cls, Class argType1, Class argType2, Class argType3, Class argType4, Class argType5) {
        Class[] argTypes = new Class[]{argType1, argType2, argType3, argType4, argType5};
        return sc.constructor(cls, argTypes);
    }

    public static final MethodRef constructor(Class cls, Class argType1, Class argType2, Class argType3, Class argType4, Class argType5, Class argType6) {
        Class[] argTypes = new Class[]{argType1, argType2, argType3, argType4, argType5, argType6};
        return sc.constructor(cls, argTypes);
    }

    public static final MethodRef constructor(Class cls, Class argType1, Class argType2, Class argType3, Class argType4, Class argType5, Class argType6, Class argType7) {
        Class[] argTypes = new Class[]{argType1, argType2, argType3, argType4, argType5, argType6, argType7};
        return sc.constructor(cls, argTypes);
    }

    public static final MethodRef constructor(Class cls, Class argType1, Class argType2, Class argType3, Class argType4, Class argType5, Class argType6, Class argType7, Class argType8) {
        Class[] argTypes = new Class[]{argType1, argType2, argType3, argType4, argType5, argType6, argType7, argType8};
        return sc.constructor(cls, argTypes);
    }

    public static final MethodRef constructor(Class cls, Class argType1, Class argType2, Class argType3, Class argType4, Class argType5, Class argType6, Class argType7, Class argType8, Class argType9) {
        Class[] argTypes = new Class[]{argType1, argType2, argType3, argType4, argType5, argType6, argType7, argType8, argType9};
        return sc.constructor(cls, argTypes);
    }

    public static final String descriptor(Class returnType, Class[] args) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        int i = 0;
        while (i < args.length) {
            sb.append(sc.classDescriptor(args[i]));
            ++i;
        }
        sb.append(")");
        sb.append(sc.classDescriptor(returnType));
        return sb.toString();
    }

    public static final String descriptor(Class returnType, Class argType1) {
        Class[] argTypes = new Class[]{argType1};
        return sc.descriptor(returnType, argTypes);
    }

    public static final String descriptor(Class returnType, Class argType1, Class argType2) {
        Class[] argTypes = new Class[]{argType1, argType2};
        return sc.descriptor(returnType, argTypes);
    }

    public static final String descriptor(Class returnType, Class argType1, Class argType2, Class argType3) {
        Class[] argTypes = new Class[]{argType1, argType2, argType3};
        return sc.descriptor(returnType, argTypes);
    }

    public static final String descriptor(Class returnType, Class argType1, Class argType2, Class argType3, Class argType4) {
        Class[] argTypes = new Class[]{argType1, argType2, argType3, argType4};
        return sc.descriptor(returnType, argTypes);
    }

    public static final String descriptor(Class returnType, Class argType1, Class argType2, Class argType3, Class argType4, Class argType5) {
        Class[] argTypes = new Class[]{argType1, argType2, argType3, argType4, argType5};
        return sc.descriptor(returnType, argTypes);
    }

    public static final String descriptor(Class returnType, Class argType1, Class argType2, Class argType3, Class argType4, Class argType5, Class argType6) {
        Class[] argTypes = new Class[]{argType1, argType2, argType3, argType4, argType5, argType6};
        return sc.descriptor(returnType, argTypes);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

