/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.marshal.ExternalizeDelegate;
import com.kingdee.util.marshal.IMarshalObject;
import com.kingdee.util.marshal.Marshaller;
import com.kingdee.util.marshal.Unmarshaller;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class Context
implements IMarshalObject {
    private static final Logger logger = Logger.getLogger(Context.class);
    public static final String OBJECT_CONTEXT_FEATURE = "IS_OBJECT_CONTEXT";
    public static final String CURRENT_MODE = "current_mode";
    public static final String DEBUG = "DEBUG";
    public static final String STUDIO = "STUDIO";
    public static final String METADATAPATH = "METADATAPATH";
    public static final String DEVMETADATALOADER = "DEVMETADATALOADER";
    private String contextID;
    private IObjectPK userID = null;
    private String solution = null;
    private String ais = null;
    private String readAis = null;
    private Locale locale = null;
    private Locale originLocale = null;
    private String clientHostIP = null;
    private String clientHostName = null;
    private String userName = null;
    protected Map<Object, Object> ctx = new ConcurrentHashMap<Object, Object>();

    public Context() {
        this(null, null, null, null, null);
    }

    public Context(String slnName) {
        this(null, slnName, null, null, null);
    }

    public Context(IObjectPK userID, String solution, String ais, Locale originLocale) {
        this(userID, solution, ais, originLocale, null);
    }

    public Context(IObjectPK userID, String solution, String ais, Locale originLocale, String contextID) {
        this.userID = userID;
        this.ais = ais;
        this.solution = solution;
        this.initLocale(originLocale);
        logger.debug((Object)("old contextID is " + contextID));
        this.contextID = contextID != null ? contextID : Uuid.create().toString();
    }

    private void initLocale(Locale locale) {
        this.locale = LocaleUtils.getShortLocale(locale);
        this.originLocale = LocaleUtils.getFirstOriginLocale(locale);
    }

    public String[] getUserDefineFields() {
        return this.ctx.keySet().toArray(new String[0]);
    }

    public Set<Object> getUserDefineFieldKeySet() {
        return this.ctx.keySet();
    }

    public Object get(Object key, Object defaultValue) {
        if (key == null || this.ctx.get(key) == null) {
            return defaultValue;
        }
        return this.ctx.get(key);
    }

    public Object get(Object key) {
        if (key == null) {
            return null;
        }
        return this.ctx.get(key);
    }

    public void put(Object key, Object value) {
        if (key == null) {
            return;
        }
        if (value == null) {
            this.ctx.remove(key);
            return;
        }
        this.ctx.put(key, value);
    }

    public Object remove(Object key) {
        if (key == null) {
            return null;
        }
        return this.ctx.remove(key);
    }

    public IObjectPK getCaller() {
        return this.userID;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            return LocaleUtils.locale_l2;
        }
        return this.locale;
    }

    public Locale getOriginLocale() {
        if (this.originLocale == null) {
            return LocaleUtils.locale_zh_CN;
        }
        return this.originLocale;
    }

    public String getSolution() {
        return this.solution;
    }

    public void setSolution(String solution) {
        this.solution = solution;
    }

    public void setCaller(IObjectPK userID) {
        this.userID = userID;
    }

    public void setLocale(Locale locale) {
        this.initLocale(locale);
    }

    public String getContextID() {
        return this.contextID;
    }

    public String getAIS() {
        return this.ais;
    }

    public void setAIS(String ais) {
        if (this.ais != null) {
            throw new IllegalArgumentException("ais is not null, not allowed to duplicate set.");
        }
        this.ais = ais;
    }

    public String getReadAIS() {
        return this.readAis;
    }

    public void setReadAIS(String ais) {
        this.readAis = ais;
    }

    public void setClientHostIP(String clientHostIP) {
        this.clientHostIP = clientHostIP;
    }

    public void setClientHostName(String clientHostName) {
        this.clientHostName = clientHostName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getClientHostIP() {
        return this.clientHostIP;
    }

    public String getClientHostName() {
        return this.clientHostName;
    }

    public String getUserName() {
        return this.userName;
    }

    @Override
    public void marshal(Marshaller marshaller) throws IOException {
        marshaller.writeObject(this.contextID);
        marshaller.writeObject(this.userID);
        marshaller.writeObject(this.solution);
        marshaller.writeObject(this.ais);
        marshaller.writeObject(this.locale);
        marshaller.writeObject(this.originLocale);
        marshaller.writeObject(this.clientHostIP);
        marshaller.writeObject(this.clientHostName);
        marshaller.writeObject(this.userName);
        ArrayList<Map.Entry<Object, Object>> clone = new ArrayList<Map.Entry<Object, Object>>();
        clone.addAll(this.ctx.entrySet());
        marshaller.writeInt(clone.size());
        for (Map.Entry entry : clone) {
            marshaller.writeObject(entry.getKey());
            marshaller.writeObject(entry.getValue());
        }
    }

    @Override
    public void unmarshal(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        this.contextID = unmarshaller.readObject().toString();
        this.userID = (IObjectPK)unmarshaller.readObject();
        this.solution = (String)unmarshaller.readObject();
        this.ais = (String)unmarshaller.readObject();
        this.locale = (Locale)unmarshaller.readObject();
        this.originLocale = (Locale)unmarshaller.readObject();
        this.clientHostIP = (String)unmarshaller.readObject();
        this.clientHostName = (String)unmarshaller.readObject();
        this.userName = (String)unmarshaller.readObject();
        int size = unmarshaller.readInt();
        for (int i = 0; i < size; ++i) {
            Object key = unmarshaller.readObject();
            Object val = unmarshaller.readObject();
            this.put(key, val);
        }
    }

    @Override
    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        new ExternalizeDelegate(this).readExternal(in);
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        new ExternalizeDelegate(this).writeExternal(out);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.userID != null) {
            sb.append(this.userID);
            sb.append("|");
        }
        if (this.solution != null) {
            sb.append(this.solution);
            sb.append("|");
        }
        if (this.ais != null) {
            sb.append(this.ais);
            sb.append("|");
        }
        if (this.locale != null) {
            sb.append(this.locale);
            sb.append("|");
        }
        if (this.locale != null) {
            sb.append(this.originLocale);
            sb.append("|");
        }
        if (this.clientHostIP != null) {
            sb.append(this.clientHostIP);
            sb.append("|");
        }
        if (this.clientHostName != null) {
            sb.append(this.clientHostName);
            sb.append("|");
        }
        if (this.userName != null) {
            sb.append(this.userName);
            sb.append("|");
        }
        if (this.ctx != null) {
            sb.append(this.ctx);
        }
        return sb.toString();
    }
}

