/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.simulation;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.simulation.SimulationContext;

public class SimulationExecutor {
    private ThreadLocal threadLocal = new ThreadLocal();

    public void start(Context bosContext, SimulationContext ctx) {
        this.threadLocal.set(ctx);
        ctx.setStage("START");
    }

    public void loopStepStart(Context bosContext, SimulationContext ctx) {
        ctx.setStage("LOOPING");
    }

    public void loopStepEnd(Context bosContext, SimulationContext ctx) throws BOSException {
        ctx.incLoopTimes();
    }

    public void finished(Context bosContext, SimulationContext ctx) {
        ctx.setStage("FINISHED");
    }

    public boolean needContinue(SimulationContext ctx) {
        return false;
    }

    public void end(Context bosContext, SimulationContext ctx) {
        ctx.setStage("END");
        this.threadLocal.remove();
    }

    public boolean isRunning() {
        return this.threadLocal.get() != null;
    }

    public SimulationContext getContext() {
        return (SimulationContext)this.threadLocal.get();
    }
}

