/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.util;

import org.apache.log4j.Logger;

public class Counter
extends Thread {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.util.Counter");
    String name;
    long count = 0L;
    long lastTime = 0L;

    public Counter(String _name) {
        this.name = _name;
        this.setDaemon(true);
    }

    public synchronized void add(int n) {
        this.add((long)n);
    }

    public synchronized void add(long n) {
        if (this.count == 0L) {
            this.start();
        }
        this.count += n;
        this.lastTime = System.currentTimeMillis();
    }

    public synchronized long getCount() {
        return this.count;
    }

    public void add() {
        this.add(1L);
    }

    @Override
    public void run() {
        long startTime = System.currentTimeMillis();
        long maxSpeed = 0L;
        block2: while (true) {
            int i = 0;
            while (true) {
                if (i >= 10) continue block2;
                if (i == 0) {
                    logger.debug((Object)"------------------------------------------------------------------");
                    logger.debug((Object)(Counter.fixl("TotalTime", 12) + Counter.fixl("ActiveTime", 12) + Counter.fixr("TotalCount", 12) + Counter.fixr("CurCPS", 10) + Counter.fixr("AveCPS", 10) + Counter.fixr("MaxCPS", 10)));
                    logger.debug((Object)"------------------------------------------------------------------");
                }
                try {
                    long c0 = this.getCount();
                    long t0 = System.currentTimeMillis();
                    Counter.sleep(3000L);
                    long c1 = this.getCount();
                    long t1 = System.currentTimeMillis();
                    long totalTime = t1 - startTime;
                    long curTime = t1 - t0;
                    long total = c1;
                    long curCount = total - c0;
                    long curSpeed = curCount * 1000L / curTime;
                    long activeTime = this.lastTime - startTime;
                    long aveSpeed = total * 1000L / activeTime;
                    if (curSpeed > maxSpeed) {
                        maxSpeed = curSpeed;
                    }
                    logger.debug((Object)(Counter.fixl(Counter.getTimeString(totalTime), 12) + Counter.fixl(Counter.getTimeString(activeTime), 12) + Counter.fixr("" + total, 12) + Counter.fixr("" + curSpeed, 10) + Counter.fixr("" + aveSpeed, 10) + Counter.fixr("" + maxSpeed, 10)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
            break;
        }
    }

    static String getTimeString(long ms) {
        long s = ms / 1000L;
        long h = s / 3600L;
        long m = (s - h * 3600L) / 60L;
        s = s - h * 3600L - m * 60L;
        return Counter.fix(h, 3) + ":" + Counter.fix(m) + ":" + Counter.fix(s);
    }

    static String fix(long n) {
        return Counter.fix(n, 2);
    }

    static String fix(long n, int l) {
        String s = "0000" + n;
        return s.substring(s.length() - l, s.length());
    }

    static String fixl(String s, int len) {
        return (s + "                              ").substring(0, len);
    }

    static String fixr(String s, int len) {
        s = "                                 " + s;
        return s.substring(s.length() - len, s.length());
    }
}

