/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.util;

import com.kingdee.bos.util.StringComparator;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Logger;

public class EasyTool {
    private static Logger logger = Logger.getLogger(EasyTool.class);

    public static void closeAny(Object x) {
        try {
            if (x == null) {
                return;
            }
            if (x instanceof InputStream) {
                ((InputStream)x).close();
            } else if (x instanceof OutputStream) {
                ((OutputStream)x).close();
            } else if (x instanceof Socket) {
                ((Socket)x).close();
            } else if (x instanceof ServerSocket) {
                ((ServerSocket)x).close();
            } else {
                x.getClass().getMethod("close", new Class[0]).invoke(x, new Object[0]);
            }
        }
        catch (Exception e) {
            logger.warn((Object)e, (Throwable)e);
        }
    }

    public static Object[] copyArray(Enumeration e) {
        return EasyTool.copyArray(e, Object.class);
    }

    public static Object[] copyArray(Enumeration e, Class type) {
        Vector v = new Vector();
        while (e.hasMoreElements()) {
            v.addElement(e.nextElement());
        }
        return EasyTool.copyArray(v, type);
    }

    public static Object[] copyArray(Vector v) {
        return EasyTool.copyArray(v, Object.class);
    }

    public static Object[] copyArray(Vector v, Class type) {
        Object[] ar = (Object[])Array.newInstance(type, v.size());
        v.copyInto(ar);
        return ar;
    }

    public static void sort(String[] stringArray) {
        Arrays.sort(stringArray, new StringComparator());
    }

    public static String readLine(InputStream in) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        while (true) {
            int b;
            if ((b = in.read()) == -1) {
                throw new EOFException();
            }
            if (b == 10) break;
            if (b == 13) continue;
            bout.write(b);
        }
        return new String(bout.toByteArray());
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[4096];
        while ((len = in.read(buf)) > 0) {
            if (out == null) continue;
            out.write(buf, 0, len);
        }
    }

    public static void writeString(OutputStream out, String s) throws IOException {
        out.write(s.getBytes());
    }

    public static void writeLine(OutputStream out) throws IOException {
        EasyTool.writeString(out, "\r\n");
    }

    public static void writeLine(OutputStream out, String line) throws IOException {
        if (line == null) {
            EasyTool.writeString(out, "\r\n");
        } else {
            EasyTool.writeString(out, line + "\r\n");
        }
    }

    public static void readFully(InputStream in, byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            int r = in.read(b, off, len);
            if (r <= 0) {
                throw new EOFException();
            }
            off += r;
            len -= r;
        }
    }

    public static void readFully(InputStream in, byte[] b) throws IOException {
        EasyTool.readFully(in, b, 0, b.length);
    }

    public static Class arrayClass(Class type) {
        return Array.newInstance(type, 0).getClass();
    }

    public static Class arrayClass(Class type, int dims) {
        int[] lens = new int[dims];
        return Array.newInstance(type, lens).getClass();
    }

    public static Object[] objectArray(Object item) {
        Object[] ar = new Object[]{item};
        return ar;
    }

    public static Object[] objectArray(Object item1, Object item2) {
        Object[] ar = new Object[]{item1, item2};
        return ar;
    }

    public static Object[] objectArray(Object item1, Object item2, Object item3) {
        Object[] ar = new Object[]{item1, item2, item3};
        return ar;
    }

    public static Object[] objectArray(Object item1, Object item2, Object item3, Object item4) {
        Object[] ar = new Object[]{item1, item2, item3, item4};
        return ar;
    }

    public static Object[] objectArray(Object item1, Object item2, Object item3, Object item4, Object item5) {
        Object[] ar = new Object[]{item1, item2, item3, item4, item5};
        return ar;
    }

    public static Object[] objectArray(Object item1, Object item2, Object item3, Object item4, Object item5, Object item6) {
        Object[] ar = new Object[]{item1, item2, item3, item4, item5, item6};
        return ar;
    }

    public static Class[] classArray(Class item) {
        Class[] ar = new Class[]{item};
        return ar;
    }

    public static Class[] classArray(Class item1, Class item2) {
        Class[] ar = new Class[]{item1, item2};
        return ar;
    }

    public static Class[] classArray(Class item1, Class item2, Class item3) {
        Class[] ar = new Class[]{item1, item2, item3};
        return ar;
    }

    public static Class[] classArray(Class item1, Class item2, Class item3, Class item4) {
        Class[] ar = new Class[]{item1, item2, item3, item4};
        return ar;
    }

    public static Class[] classArray(Class item1, Class item2, Class item3, Class item4, Class item5) {
        Class[] ar = new Class[]{item1, item2, item3, item4, item5};
        return ar;
    }

    public static Class[] classArray(Class item1, Class item2, Class item3, Class item4, Class item5, Class item6) {
        Class[] ar = new Class[]{item1, item2, item3, item4, item5, item6};
        return ar;
    }

    public static void writeString(ObjectOutputStream out, String s) throws IOException {
        if (s == null) {
            out.writeInt(-1);
        } else {
            byte[] b = s.getBytes();
            out.writeInt(b.length);
            if (b.length > 0) {
                out.write(b);
            }
        }
    }

    public static String readString(ObjectInputStream in) throws IOException {
        int len = in.readInt();
        if (len < 0) {
            return null;
        }
        byte[] b = new byte[len];
        if (len > 0) {
            in.readFully(b);
        }
        return new String(b);
    }

    public static void writeString(DataOutputStream out, String s) throws IOException {
        if (s == null) {
            out.writeInt(-1);
        } else {
            byte[] b = s.getBytes();
            out.writeInt(b.length);
            if (b.length > 0) {
                out.write(b);
            }
        }
    }

    public static String readString(DataInputStream in) throws IOException {
        int len = in.readInt();
        if (len < 0) {
            return null;
        }
        byte[] b = new byte[len];
        if (len > 0) {
            in.readFully(b);
        }
        return new String(b);
    }
}

