/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.util;

import java.util.LinkedList;

public class ThreadPool {
    static final long IDLE_TIMEOUT = 60000L;
    private String name;
    private int minsize;
    private int maxsize;
    private int nextWorkerId = 0;
    private LinkedList pool = new LinkedList();

    public ThreadPool() {
        this("PooledThread");
    }

    public ThreadPool(String name) {
        this(name, 0, 20);
    }

    public ThreadPool(String name, int minsize, int maxsize) {
        this.name = name;
        this.minsize = minsize;
        this.maxsize = maxsize;
    }

    public String getName() {
        return this.name;
    }

    public long getIdleTimeout() {
        return 60000L;
    }

    public synchronized void setSize(int min, int max) {
        this.minsize = min;
        this.maxsize = max;
    }

    public synchronized int getMinSize() {
        return this.minsize;
    }

    public synchronized int getMaxSize() {
        return this.maxsize;
    }

    public synchronized void run(Runnable runner) {
        Worker worker;
        if (runner == null) {
            throw new NullPointerException();
        }
        if (!this.pool.isEmpty()) {
            worker = (Worker)this.pool.removeFirst();
        } else {
            worker = new Worker(this.name + "-" + ++this.nextWorkerId);
            worker.start();
        }
        worker.wakeup(runner);
    }

    synchronized boolean notifyTimeout(Worker worker) {
        if (worker.runner != null) {
            return false;
        }
        if (this.pool.size() > this.minsize) {
            this.pool.remove(worker);
            return true;
        }
        return false;
    }

    synchronized boolean notifyFree(Worker worker) {
        if (this.pool.size() < this.maxsize) {
            this.pool.addLast(worker);
            return false;
        }
        return true;
    }

    class Worker
    extends Thread {
        Runnable runner;

        public Worker(String name) {
            super(name);
            this.runner = null;
            this.setDaemon(true);
        }

        synchronized void wakeup(Runnable runner) {
            this.runner = runner;
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Worker worker = this;
                synchronized (worker) {
                    if (this.runner == null) {
                        try {
                            this.wait(60000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                if (this.runner == null) {
                    if (!ThreadPool.this.notifyTimeout(this)) continue;
                    return;
                }
                try {
                    this.runner.run();
                    continue;
                }
                finally {
                    this.runner = null;
                    if (!ThreadPool.this.notifyFree(this)) continue;
                    return;
                    continue;
                }
                break;
            }
        }
    }
}

