/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.util;

import com.kingdee.bos.util.NoBOMInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLParser {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.util.XMLParser");

    public static Document parseXML(InputStream inputStream) throws JDOMException, IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("The argument inputStream is null");
        }
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(SAXBuilder.class.getClassLoader());
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            doc = builder.build((InputStream)new NoBOMInputStream(inputStream));
        }
        catch (JDOMException je) {
            logger.fatal((Object)"JDOM Parser ERROR!");
            logger.fatal((Object)("this classloader = " + XMLParser.class.getClassLoader()));
            logger.fatal((Object)("thread classloader = " + Thread.currentThread().getContextClassLoader()));
            logger.fatal((Object)("system classloader = " + ClassLoader.getSystemClassLoader()));
            throw je;
        }
        finally {
            try {
                Thread.currentThread().setContextClassLoader(oldCL);
            }
            catch (SecurityException securityException) {}
        }
        return doc;
    }

    public static Document parseXML(Reader reader) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(SAXBuilder.class.getClassLoader());
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            doc = builder.build(reader);
        }
        catch (JDOMException je) {
            logger.fatal((Object)"JDOM Parser ERROR!");
            logger.fatal((Object)("this classloader = " + XMLParser.class.getClassLoader()));
            logger.fatal((Object)("thread classloader = " + Thread.currentThread().getContextClassLoader()));
            logger.fatal((Object)("system classloader = " + ClassLoader.getSystemClassLoader()));
            throw je;
        }
        finally {
            try {
                Thread.currentThread().setContextClassLoader(oldCL);
            }
            catch (SecurityException securityException) {}
        }
        return doc;
    }

    public static SAXParserFactory createSAXParser() throws FactoryConfigurationError {
        SAXParserFactory factory = null;
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(SAXBuilder.class.getClassLoader());
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            factory = SAXParserFactory.newInstance();
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (FactoryConfigurationError e) {
            logger.fatal((Object)"JAXP Parser ERROR!");
            logger.fatal((Object)("this classloader = " + XMLParser.class.getClassLoader()));
            logger.fatal((Object)("thread classloader = " + Thread.currentThread().getContextClassLoader()));
            logger.fatal((Object)("system classloader = " + ClassLoader.getSystemClassLoader()));
            throw e;
        }
        catch (SAXNotRecognizedException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SAXNotSupportedException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                Thread.currentThread().setContextClassLoader(oldCL);
            }
            catch (SecurityException e) {}
        }
        return factory;
    }

    public static void parseXML(InputStream in, DefaultHandler handler) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        SAXParser saxParser = XMLParser.createSAXParser().newSAXParser();
        saxParser.parse((InputStream)new NoBOMInputStream(in), handler);
    }

    public static void parseXML(Reader reader, DefaultHandler handler) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        SAXParser saxParser = XMLParser.createSAXParser().newSAXParser();
        saxParser.parse(new InputSource(reader), handler);
    }
}

