/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.util.backport.concurrent;

import com.kingdee.bos.util.backport.concurrent.AbstractExecutorService;
import com.kingdee.bos.util.backport.concurrent.BlockingQueue;
import com.kingdee.bos.util.backport.concurrent.Callable;
import com.kingdee.bos.util.backport.concurrent.CompletionService;
import com.kingdee.bos.util.backport.concurrent.Executor;
import com.kingdee.bos.util.backport.concurrent.Future;
import com.kingdee.bos.util.backport.concurrent.FutureTask;
import com.kingdee.bos.util.backport.concurrent.LinkedBlockingQueue;
import com.kingdee.bos.util.backport.concurrent.RunnableFuture;
import com.kingdee.bos.util.backport.concurrent.TimeUnit;

public class ExecutorCompletionService
implements CompletionService {
    private final Executor executor;
    private final AbstractExecutorService aes;
    private final BlockingQueue completionQueue;

    private RunnableFuture newTaskFor(Callable task) {
        if (this.aes == null) {
            return new FutureTask(task);
        }
        return this.aes.newTaskFor(task);
    }

    private RunnableFuture newTaskFor(Runnable task, Object result) {
        if (this.aes == null) {
            return new FutureTask(task, result);
        }
        return this.aes.newTaskFor(task, result);
    }

    public ExecutorCompletionService(Executor executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        this.executor = executor;
        this.aes = executor instanceof AbstractExecutorService ? (AbstractExecutorService)executor : null;
        this.completionQueue = new LinkedBlockingQueue();
    }

    public ExecutorCompletionService(Executor executor, BlockingQueue completionQueue) {
        if (executor == null || completionQueue == null) {
            throw new NullPointerException();
        }
        this.executor = executor;
        this.aes = executor instanceof AbstractExecutorService ? (AbstractExecutorService)executor : null;
        this.completionQueue = completionQueue;
    }

    @Override
    public Future submit(Callable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture f = this.newTaskFor(task);
        this.executor.execute(new QueueingFuture(f));
        return f;
    }

    @Override
    public Future submit(Runnable task, Object result) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture f = this.newTaskFor(task, result);
        this.executor.execute(new QueueingFuture(f));
        return f;
    }

    @Override
    public Future take() throws InterruptedException {
        return (Future)this.completionQueue.take();
    }

    @Override
    public Future poll() {
        return (Future)this.completionQueue.poll();
    }

    @Override
    public Future poll(long timeout, TimeUnit unit) throws InterruptedException {
        return (Future)this.completionQueue.poll(timeout, unit);
    }

    private class QueueingFuture
    extends FutureTask {
        private final Future task;

        QueueingFuture(RunnableFuture task) {
            super(task, null);
            this.task = task;
        }

        @Override
        protected void done() {
            ExecutorCompletionService.this.completionQueue.add(this.task);
        }
    }
}

