/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.jdbc.rowset.impl;

import com.kingdee.jdbc.rowset.impl.SerialArray;
import com.kingdee.jdbc.rowset.impl.SerialBlob;
import com.kingdee.jdbc.rowset.impl.SerialClob;
import com.kingdee.jdbc.rowset.impl.SerialStruct;
import java.io.Serializable;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Struct;

abstract class AbstractRow
implements Serializable,
Cloneable {
    protected Object[] vals;

    AbstractRow() {
    }

    protected abstract Object getColumnObject(int var1) throws SQLException;

    protected abstract void setColumnObject(int var1, Object var2) throws SQLException;

    protected Object[] getOrigRow() {
        return this.vals;
    }

    protected Object serializeColumnObject(Object obj) throws SQLException {
        Object retObj;
        if (obj instanceof String) {
            retObj = obj;
        } else if (obj instanceof Struct) {
            retObj = new SerialStruct((Struct)obj, null);
        } else if (obj instanceof SQLData) {
            retObj = new SerialStruct((SQLData)obj, null);
        } else if (obj instanceof Blob) {
            if (((Blob)obj).length() == 0L) {
                return null;
            }
            retObj = new SerialBlob((Blob)obj);
        } else if (obj instanceof Clob) {
            if (((Clob)obj).length() == 0L) {
                return null;
            }
            retObj = new SerialClob((Clob)obj);
        } else {
            retObj = obj instanceof Array ? new SerialArray((Array)obj, null) : obj;
        }
        return retObj;
    }
}

