/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.jdbc.rowset.impl;

import com.kingdee.jdbc.rowset.FetchedTooMuchRowsException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.AbstractRow;
import com.kingdee.jdbc.rowset.impl.AbstractRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicColInfo;
import com.kingdee.jdbc.rowset.impl.InsertRow;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.jdbc.rowset.impl.Row;
import com.kingdee.jdbc.rowset.impl.RowSetMetaDataImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;

public final class DynamicRowSet
extends AbstractRowSet {
    private transient InsertRow insertRow;
    private transient boolean onInsertRow;

    public DynamicRowSet() {
    }

    public DynamicRowSet(int colCount) throws SQLException {
        this.onInsertRow = false;
        this.insertRow = null;
        this.rowSetMD = new RowSetMetaDataImpl(colCount);
    }

    public static DynamicRowSet create(IRowSet rs) throws SQLException {
        if (rs == null) {
            return null;
        }
        ResultSetMetaData meta = rs.getMetaData();
        if (meta == null) {
            return null;
        }
        int colCount = meta.getColumnCount();
        DynamicRowSet drs = new DynamicRowSet(colCount);
        for (int i = 1; i <= colCount; ++i) {
            ColInfo col = new ColInfo(meta.getColumnName(i), meta.getColumnLabel(i), meta.getColumnType(i), null);
            drs.setColInfo(i, col);
        }
        return drs;
    }

    public DynamicRowSet subRowSet(int start, int length) throws SQLException {
        DynamicRowSet newRs = new DynamicRowSet();
        List li = this.cachedRows.subList(start, length);
        for (Row row : li) {
            Row newRow = new Row(row.vals.length);
            System.arraycopy(row.vals, 0, newRow.vals, 0, row.vals.length);
            newRs.cachedRows.add(row);
        }
        newRs.rowSetMD = new RowSetMetaDataImpl(this.rowSetMD.getColumnCount());
        RowSetMetaDataImpl newMd = (RowSetMetaDataImpl)newRs.rowSetMD;
        RowSetMetaDataImpl md = (RowSetMetaDataImpl)this.rowSetMD;
        if (md.unsupportedMethods != null) {
            newMd.unsupportedMethods = new HashSet(md.unsupportedMethods);
        }
        int count = md.getColumnCount();
        for (int i = 1; i <= count; ++i) {
            ColInfo colInfo = md.colInfo[i];
            DynamicColInfo dc = new DynamicColInfo();
            if (colInfo.extendedProps != null) {
                dc.extendedProps = new Hashtable(colInfo.extendedProps);
            }
            dc.autoIncrement = colInfo.autoIncrement;
            dc.caseSensitive = colInfo.caseSensitive;
            dc.currency = colInfo.currency;
            dc.nullable = colInfo.nullable;
            dc.signed = colInfo.signed;
            dc.searchable = colInfo.searchable;
            dc.columnDisplaySize = colInfo.columnDisplaySize;
            dc.columnLabel = colInfo.columnLabel;
            dc.columnName = colInfo.columnName;
            dc.schemaName = colInfo.schemaName;
            dc.colPrecision = colInfo.colPrecision;
            dc.colScale = colInfo.colScale;
            dc.tableName = colInfo.tableName;
            dc.catName = colInfo.catName;
            dc.colType = colInfo.colType;
            dc.colTypeName = colInfo.colTypeName;
            dc.inaccessible = colInfo.inaccessible;
            newMd.setColInfo(i, dc);
        }
        newRs.numRows = length;
        return newRs;
    }

    public void merge(DynamicRowSet rowSet) {
        this.cachedRows.addAll(rowSet.cachedRows);
        this.numRows += rowSet.size();
    }

    public void setColInfo(int i, ColInfo colInfo) throws SQLException {
        ((RowSetMetaDataImpl)this.rowSetMD).setColInfo(i, DynamicColInfo.copyFrom(colInfo));
    }

    public void setColInfo(int i, String columnName, String columnLabel, int colType, Hashtable extProps) throws SQLException {
        this.setColInfo(i, new DynamicColInfo(columnName, columnLabel, colType, extProps));
    }

    @Override
    protected AbstractRow getCurrentRow() {
        if (this.onInsertRow) {
            return this.insertRow;
        }
        return super.getCurrentRow();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.checkCursor();
        if (this.onInsertRow) {
            throw new SQLException("Invalid cursor position.");
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void insertRows(IRowSet rowSet) throws SQLException {
        if (rowSet == null) {
            return;
        }
        ResultSetMetaData metadata = rowSet.getMetaData();
        if (this.rowSetMD == null || metadata == null) {
            return;
        }
        int columnCount = this.rowSetMD.getColumnCount();
        if (metadata.getColumnCount() != columnCount) {
            return;
        }
        rowSet.beforeFirst();
        while (rowSet.next()) {
            this.moveToInsertRow();
            for (int i = 1; i <= columnCount; ++i) {
                Object value;
                try {
                    value = rowSet.getObject(i);
                    this.updateObject(i, value);
                    continue;
                }
                catch (SQLException e) {
                    value = null;
                }
            }
            this.insertRow();
        }
        rowSet.beforeFirst();
    }

    @Override
    public void insertRow() throws SQLException {
        if (!this.onInsertRow || !this.insertRow.isCompleteRow(this.rowSetMD)) {
            throw new SQLException("Failed to insert Row");
        }
        Row row = new Row(this.rowSetMD.getColumnCount(), this.insertRow.getOrigRow());
        int i = this.currentRow >= this.numRows || this.currentRow < 0 ? this.numRows : this.currentRow;
        this.cachedRows.add(i, row);
        ++this.numRows;
        if (this.numRows > JdbcRowSet.CriticalIDList) {
            throw new FetchedTooMuchRowsException(this.numRows);
        }
        this.onInsertRow = false;
        this.notifyRowChanged();
    }

    @Override
    public void updateRow() throws SQLException {
        if (this.onInsertRow) {
            throw new SQLException("updateRow called while on insert row");
        }
        this.notifyRowChanged();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        if (this.onInsertRow) {
            this.cursorPos = this.currentRow;
            this.onInsertRow = false;
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        int i;
        if (this.getType() == 1003) {
            throw new SQLException("last: TYPE_FORWARD_ONLY");
        }
        if (this.insertRow == null && (i = this.rowSetMD.getColumnCount()) > 0) {
            this.insertRow = new InsertRow(i);
        }
        this.onInsertRow = true;
        this.currentRow = this.cursorPos;
        this.cursorPos = -1;
        this.insertRow.initInsertRow();
    }

    @Override
    public void updateAsciiStream(int i, InputStream inputstream, int j) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(String s, InputStream inputstream, int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBigDecimal(int i, BigDecimal bigdecimal) throws SQLException {
        this.checkIndex(i);
        this.checkCursor();
        Object obj = this.convertNumeric(bigdecimal, 2, this.rowSetMD.getColumnType(i));
        this.getCurrentRow().setColumnObject(i, obj);
    }

    @Override
    public void updateBigDecimal(String s, BigDecimal bigdecimal) throws SQLException {
        this.updateBigDecimal(this.getColIdxByName(s), bigdecimal);
    }

    @Override
    public void updateBinaryStream(int i, InputStream inputstream, int j) throws SQLException {
        this.checkIndex(i);
        this.checkCursor();
        if (!this.isBinary(this.rowSetMD.getColumnType(i))) {
            throw new SQLException("Data Type Mismatch");
        }
        byte[] abyte0 = new byte[j];
        try {
            int k = 0;
            while ((k += inputstream.read(abyte0, k, j - k)) != -1) {
            }
        }
        catch (IOException _ex) {
            throw new SQLException("read failed for binaryStream");
        }
        this.getCurrentRow().setColumnObject(i, abyte0);
    }

    @Override
    public void updateBinaryStream(String s, InputStream inputstream, int i) throws SQLException {
        this.updateBinaryStream(this.getColIdxByName(s), inputstream, i);
    }

    @Override
    public void updateBoolean(int i, boolean flag) throws SQLException {
        this.checkIndex(i);
        this.checkCursor();
        Object obj = this.convertNumeric(flag, -7, this.rowSetMD.getColumnType(i));
        this.getCurrentRow().setColumnObject(i, obj);
    }

    @Override
    public void updateBoolean(String s, boolean flag) throws SQLException {
        this.updateBoolean(this.getColIdxByName(s), flag);
    }

    @Override
    public void updateByte(int i, byte byte0) throws SQLException {
        this.checkIndex(i);
        this.checkCursor();
        Object obj = this.convertNumeric(new Byte(byte0), -6, this.rowSetMD.getColumnType(i));
        this.getCurrentRow().setColumnObject(i, obj);
    }

    @Override
    public void updateByte(String s, byte byte0) throws SQLException {
        this.updateByte(this.getColIdxByName(s), byte0);
    }

    @Override
    public void updateBytes(int i, byte[] abyte0) throws SQLException {
        this.checkIndex(i);
        this.checkCursor();
        if (!this.isBinary(this.rowSetMD.getColumnType(i))) {
            throw new SQLException("Data Type Mismatch");
        }
        this.getCurrentRow().setColumnObject(i, abyte0);
    }

    @Override
    public void updateBytes(String s, byte[] abyte0) throws SQLException {
        this.updateBytes(this.getColIdxByName(s), abyte0);
    }

    @Override
    public void updateCharacterStream(int i, Reader reader, int j) throws SQLException {
        this.checkIndex(i);
        this.checkCursor();
        if (!this.isString(this.rowSetMD.getColumnType(i)) && !this.isBinary(this.rowSetMD.getColumnType(i))) {
            throw new SQLException("Data Type Mismatch");
        }
        char[] ac = new char[j];
        try {
            int k = 0;
            while ((k += reader.read(ac, k, j - k)) != -1) {
            }
        }
        catch (IOException _ex) {
            throw new SQLException("read failed for binaryStream");
        }
        String s = new String(ac);
        this.getCurrentRow().setColumnObject(i, s);
    }

    @Override
    public void updateCharacterStream(String s, Reader reader, int i) throws SQLException {
        this.updateCharacterStream(this.getColIdxByName(s), reader, i);
    }

    @Override
    public void updateDate(int i, Date date) throws SQLException {
        this.checkIndex(i);
        this.checkCursor();
        Object obj = this.convertTemporal(date, 91, this.rowSetMD.getColumnType(i));
        this.getCurrentRow().setColumnObject(i, obj);
    }

    @Override
    public void updateDate(String s, Date date) throws SQLException {
        this.updateDate(this.getColIdxByName(s), date);
    }

    @Override
    public void updateDouble(int i, double d) throws SQLException {
        this.checkIndex(i);
        this.checkCursor();
        Object obj = this.convertNumeric(new Double(d), 8, this.rowSetMD.getColumnType(i));
        this.getCurrentRow().setColumnObject(i, obj);
    }

    @Override
    public void updateDouble(String s, double d) throws SQLException {
        this.updateDouble(this.getColIdxByName(s), d);
    }

    @Override
    public void updateFloat(int i, float f) throws SQLException {
        this.checkIndex(i);
        this.checkCursor();
        Object obj = this.convertNumeric(new Float(f), 6, this.rowSetMD.getColumnType(i));
        this.getCurrentRow().setColumnObject(i, obj);
    }

    @Override
    public void updateFloat(String s, float f) throws SQLException {
        this.updateFloat(this.getColIdxByName(s), f);
    }

    @Override
    public void updateInt(int i, int j) throws SQLException {
        this.checkIndex(i);
        this.checkCursor();
        Object obj = this.convertNumeric(j, 4, this.rowSetMD.getColumnType(i));
        this.getCurrentRow().setColumnObject(i, obj);
    }

    @Override
    public void updateInt(String s, int i) throws SQLException {
        this.updateInt(this.getColIdxByName(s), i);
    }

    @Override
    public void updateLong(int i, long l) throws SQLException {
        this.checkIndex(i);
        this.checkCursor();
        Object obj = this.convertNumeric(l, -5, this.rowSetMD.getColumnType(i));
        this.getCurrentRow().setColumnObject(i, obj);
    }

    @Override
    public void updateLong(String s, long l) throws SQLException {
        this.updateLong(this.getColIdxByName(s), l);
    }

    @Override
    public void updateNull(int i) throws SQLException {
        this.checkIndex(i);
        this.checkCursor();
        this.getCurrentRow().setColumnObject(i, null);
    }

    @Override
    public void updateNull(String s) throws SQLException {
        this.updateNull(this.getColIdxByName(s));
    }

    @Override
    public void updateObject(int i, Object obj) throws SQLException {
        this.checkIndex(i);
        this.checkCursor();
        this.getCurrentRow().setColumnObject(i, obj);
    }

    @Override
    public void updateObject(int i, Object obj, int j) throws SQLException {
        this.checkIndex(i);
        this.checkCursor();
        int k = this.rowSetMD.getColumnType(i);
        if (k == 3 || k == 2) {
            obj = ((BigDecimal)obj).setScale(j);
        }
        this.getCurrentRow().setColumnObject(i, obj);
    }

    @Override
    public void updateObject(String s, Object obj) throws SQLException {
        this.updateObject(this.getColIdxByName(s), obj);
    }

    @Override
    public void updateObject(String s, Object obj, int i) throws SQLException {
        this.updateObject(this.getColIdxByName(s), obj, i);
    }

    @Override
    public void updateShort(int i, short word0) throws SQLException {
        this.checkIndex(i);
        this.checkCursor();
        Object obj = this.convertNumeric(new Short(word0), 5, this.rowSetMD.getColumnType(i));
        this.getCurrentRow().setColumnObject(i, obj);
    }

    @Override
    public void updateShort(String s, short word0) throws SQLException {
        this.updateShort(this.getColIdxByName(s), word0);
    }

    @Override
    public void updateString(int i, String s) throws SQLException {
        this.checkIndex(i);
        this.checkCursor();
        this.getCurrentRow().setColumnObject(i, s);
    }

    @Override
    public void updateString(String s, String s1) throws SQLException {
        this.updateString(this.getColIdxByName(s), s1);
    }

    @Override
    public void updateTime(int i, Time time) throws SQLException {
        this.checkIndex(i);
        this.checkCursor();
        Object obj = this.convertTemporal(time, 92, this.rowSetMD.getColumnType(i));
        this.getCurrentRow().setColumnObject(i, obj);
    }

    @Override
    public void updateTime(String s, Time time) throws SQLException {
        this.updateTime(this.getColIdxByName(s), time);
    }

    @Override
    public void updateTimestamp(int i, Timestamp timestamp) throws SQLException {
        this.checkIndex(i);
        this.checkCursor();
        Object obj = this.convertTemporal(timestamp, 93, this.rowSetMD.getColumnType(i));
        this.getCurrentRow().setColumnObject(i, obj);
    }

    @Override
    public void updateTimestamp(String s, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.getColIdxByName(s), timestamp);
    }

    protected Object convertNumeric(Object obj, int orgType, int destType) throws SQLException {
        if (orgType == destType) {
            return obj;
        }
        if (!this.isNumeric(destType) && !this.isString(destType)) {
            throw new SQLException("1.Datatype Mismatch: " + destType);
        }
        try {
            switch (destType) {
                case -7: {
                    Integer integer = Integer.valueOf(obj.toString().trim());
                    return integer.equals(0) ? Boolean.FALSE : Boolean.TRUE;
                }
                case -6: {
                    return new Byte(obj.toString().trim());
                }
                case 5: {
                    return new Short(obj.toString().trim());
                }
                case 4: {
                    return Integer.valueOf(obj.toString().trim());
                }
                case -5: {
                    return Long.valueOf(obj.toString().trim());
                }
                case 2: 
                case 3: {
                    return new BigDecimal(obj.toString().trim());
                }
                case 6: 
                case 7: {
                    return new Float(obj.toString().trim());
                }
                case 8: {
                    return new Double(obj.toString().trim());
                }
                case -1: 
                case 1: 
                case 12: {
                    return obj.toString();
                }
            }
            throw new SQLException("2.Data Type Mismatch: " + destType);
        }
        catch (NumberFormatException _ex) {
            throw new SQLException("3.Data Type Mismatch: " + destType);
        }
    }

    @Override
    public void execute() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCommand() {
        return null;
    }

    @Override
    public void setCommand(String s) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Object[] getParams() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearParameters() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setArray(int i, Array array) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAsciiStream(int i, InputStream inputstream, int j) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBigDecimal(int i, BigDecimal bigdecimal) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBinaryStream(int i, InputStream inputstream, int j) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBlob(int i, Blob blob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBoolean(int i, boolean flag) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setByte(int i, byte byte0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBytes(int i, byte[] abyte) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCharacterStream(int i, Reader reader, int j) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClob(int i, Clob clob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDate(int i, Date date) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDate(int i, Date date, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDouble(int i, double d) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFloat(int i, float f) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setInt(int i, int j) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLong(int i, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNull(int i, int j) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNull(int i, int j, String s) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setObject(int i, Object obj) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setObject(int i, Object obj, int j) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setObject(int i, Object obj, int j, int k) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRef(int i, Ref ref) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setShort(int i, short word0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setString(int i, String s) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTime(int i, Time time) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTime(int i, Time time, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTimestamp(int i, Timestamp timestamp) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTimestamp(int i, Timestamp timestamp, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setUnicodeStream(int i, InputStream inputstream, int j) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
    }

    @Override
    public int getHoldability() throws SQLException {
        return 0;
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, NClob clob) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, NClob clob) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNString(int columnIndex, String string) throws SQLException {
    }

    @Override
    public void updateNString(String columnLabel, String string) throws SQLException {
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public <T> T getObject(int paramInt, Class<T> paramClass) throws SQLException {
        return null;
    }

    @Override
    public <T> T getObject(String paramString, Class<T> paramClass) throws SQLException {
        return null;
    }
}

