/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.jdbc.rowset.impl;

import com.kingdee.jdbc.rowset.IRowSetMetaData;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicColInfo;
import com.kingdee.util.marshal.ExternalizeDelegate;
import com.kingdee.util.marshal.Marshaller;
import com.kingdee.util.marshal.Unmarshaller;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;

public final class RowSetMetaDataImpl
implements IRowSetMetaData {
    int colCount;
    ColInfo[] colInfo;
    HashSet unsupportedMethods;

    public RowSetMetaDataImpl() {
    }

    RowSetMetaDataImpl(int colCount) throws SQLException {
        this.setColumnCount(colCount);
    }

    void setColInfo(int i, ColInfo col) throws SQLException {
        this.checkColRange(i);
        if (this.colInfo[i] != null) {
            this.colInfo[i] = null;
        }
        this.colInfo[i] = col;
    }

    private void checkColRange(int i) throws SQLException {
        if (i <= 0 || i > this.colCount) {
            throw new SQLException("Invalid column index");
        }
    }

    @Override
    public String getCatalogName(int i) throws SQLException {
        this.isSupported("catalogName");
        this.checkColRange(i);
        return this.colInfo[i].catName;
    }

    @Override
    public String getColumnClassName(int i) throws SQLException {
        this.checkColRange(i);
        return null;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.colCount;
    }

    @Override
    public int getColumnDisplaySize(int i) throws SQLException {
        this.isSupported("columnDisplaySize");
        this.checkColRange(i);
        return this.colInfo[i].columnDisplaySize;
    }

    @Override
    public String getColumnLabel(int i) throws SQLException {
        this.isSupported("columnLabel");
        this.checkColRange(i);
        return this.colInfo[i].columnLabel;
    }

    @Override
    public String getColumnName(int i) throws SQLException {
        this.isSupported("columnName");
        this.checkColRange(i);
        return this.colInfo[i].columnName;
    }

    @Override
    public int getColumnType(int i) throws SQLException {
        this.isSupported("columnType");
        this.checkColRange(i);
        return this.colInfo[i].colType;
    }

    @Override
    public String getColumnTypeName(int i) throws SQLException {
        this.isSupported("columnTypeName");
        this.checkColRange(i);
        return this.colInfo[i].colTypeName;
    }

    @Override
    public int getPrecision(int i) throws SQLException {
        this.isSupported("precision");
        this.checkColRange(i);
        return this.colInfo[i].colPrecision;
    }

    @Override
    public int getScale(int i) throws SQLException {
        this.isSupported("scale");
        this.checkColRange(i);
        return this.colInfo[i].colScale;
    }

    @Override
    public String getSchemaName(int i) throws SQLException {
        this.isSupported("schemaName");
        this.checkColRange(i);
        return this.colInfo[i].schemaName;
    }

    @Override
    public String getTableName(int i) throws SQLException {
        this.isSupported("tableName");
        this.checkColRange(i);
        return this.colInfo[i].tableName;
    }

    @Override
    public boolean isAutoIncrement(int i) throws SQLException {
        this.isSupported("autoIncrement");
        this.checkColRange(i);
        return this.colInfo[i].autoIncrement;
    }

    @Override
    public boolean isCaseSensitive(int i) throws SQLException {
        this.isSupported("caseSensitive");
        this.checkColRange(i);
        return this.colInfo[i].caseSensitive;
    }

    @Override
    public boolean isCurrency(int i) throws SQLException {
        this.isSupported("currency");
        this.checkColRange(i);
        return this.colInfo[i].currency;
    }

    @Override
    public boolean isDefinitelyWritable(int i) throws SQLException {
        this.checkColRange(i);
        return true;
    }

    @Override
    public int isNullable(int i) throws SQLException {
        this.isSupported("nullable");
        this.checkColRange(i);
        return this.colInfo[i].nullable;
    }

    @Override
    public boolean isReadOnly(int i) throws SQLException {
        this.checkColRange(i);
        return true;
    }

    @Override
    public boolean isSearchable(int i) throws SQLException {
        this.isSupported("searchable");
        this.checkColRange(i);
        return this.colInfo[i].searchable;
    }

    @Override
    public boolean isSigned(int i) throws SQLException {
        this.isSupported("signed");
        this.checkColRange(i);
        return this.colInfo[i].signed;
    }

    @Override
    public boolean isWritable(int i) throws SQLException {
        this.checkColRange(i);
        return false;
    }

    @Override
    public boolean isInaccessible(int i) throws SQLException {
        this.checkColRange(i);
        return this.colInfo[i].inaccessible;
    }

    @Override
    public void setAutoIncrement(int i, boolean flag) throws SQLException {
        this.checkColRange(i);
        this.colInfo[i].autoIncrement = flag;
    }

    @Override
    public void setCaseSensitive(int i, boolean flag) throws SQLException {
        this.checkColRange(i);
        this.colInfo[i].caseSensitive = flag;
    }

    @Override
    public void setCatalogName(int i, String s) throws SQLException {
        this.checkColRange(i);
        this.colInfo[i].catName = s == null ? "" : s;
    }

    @Override
    public void setColumnCount(int i) throws SQLException {
        if (i <= 0) {
            throw new SQLException("Invalid column count");
        }
        this.colCount = i;
        this.colInfo = new ColInfo[this.colCount + 1];
        for (int j = 1; j <= this.colCount; ++j) {
            this.colInfo[j] = new ColInfo();
        }
    }

    @Override
    public void setColumnDisplaySize(int i, int j) throws SQLException {
        this.checkColRange(i);
        this.colInfo[i].columnDisplaySize = j;
    }

    @Override
    public void setColumnLabel(int i, String s) throws SQLException {
        this.checkColRange(i);
        this.colInfo[i].columnLabel = s == null ? "" : s;
    }

    @Override
    public void setColumnName(int i, String s) throws SQLException {
        this.checkColRange(i);
        this.colInfo[i].columnName = s;
    }

    @Override
    public void setColumnType(int i, int j) throws SQLException {
        this.checkColRange(i);
        this.colInfo[i].colType = j;
    }

    @Override
    public void setColumnTypeName(int i, String s) throws SQLException {
        this.checkColRange(i);
        this.colInfo[i].colTypeName = s;
    }

    @Override
    public void setCurrency(int i, boolean flag) throws SQLException {
        this.checkColRange(i);
        this.colInfo[i].currency = flag;
    }

    @Override
    public void setNullable(int i, int j) throws SQLException {
        this.checkColRange(i);
        this.colInfo[i].nullable = j;
    }

    @Override
    public void setPrecision(int i, int j) throws SQLException {
        this.checkColRange(i);
        this.colInfo[i].colPrecision = j;
    }

    @Override
    public void setScale(int i, int j) throws SQLException {
        this.checkColRange(i);
        this.colInfo[i].colScale = j;
    }

    @Override
    public void setSchemaName(int i, String s) throws SQLException {
        this.checkColRange(i);
        this.colInfo[i].schemaName = s == null ? "" : s;
    }

    @Override
    public void setSearchable(int i, boolean flag) throws SQLException {
        this.checkColRange(i);
        this.colInfo[i].searchable = flag;
    }

    @Override
    public void setSigned(int i, boolean flag) throws SQLException {
        this.checkColRange(i);
        this.colInfo[i].signed = flag;
    }

    @Override
    public void setTableName(int i, String s) throws SQLException {
        this.checkColRange(i);
        this.colInfo[i].tableName = s != null ? s : "";
    }

    @Override
    public void setInaccessible(int i, boolean inaccessible) throws SQLException {
        this.checkColRange(i);
        this.colInfo[i].inaccessible = inaccessible;
    }

    @Override
    public Map getExtendedProperties(int i) throws SQLException {
        this.checkColRange(i);
        return this.colInfo[i].extendedProperties();
    }

    @Override
    public int getColumnIndex(String columnName) throws SQLException {
        for (int i = 1; i < this.colInfo.length; ++i) {
            ColInfo ci = this.colInfo[i];
            if (ci == null || !ci.columnName.equalsIgnoreCase(columnName)) continue;
            return i;
        }
        throw new SQLException("Invalid column name");
    }

    protected void isSupported(String methodName) {
        if (this.unsupportedMethods == null || methodName == null) {
            return;
        }
        if (this.unsupportedMethods.contains(methodName)) {
            throw new UnsupportedOperationException("not support this method: " + methodName);
        }
    }

    protected void addUnsupportedMethod(String methodName) {
        if (methodName == null) {
            return;
        }
        if (this.unsupportedMethods == null) {
            this.unsupportedMethods = new HashSet();
        }
        this.unsupportedMethods.add(methodName);
    }

    @Override
    public void marshal(Marshaller marshaller) throws IOException {
        marshaller.writeInt(this.colCount);
        for (int i = 1; i <= this.colCount; ++i) {
            if (i == 1) {
                marshaller.writeBoolean(this.colInfo[i] instanceof DynamicColInfo);
            }
            this.colInfo[i].marshal(marshaller);
        }
        int mlen = this.unsupportedMethods == null ? 0 : this.unsupportedMethods.size();
        marshaller.writeInt(mlen);
        if (mlen > 0) {
            Object[] arr = this.unsupportedMethods.toArray();
            for (int i = 0; i < mlen; ++i) {
                marshaller.writeObject(arr[i]);
            }
        }
    }

    @Override
    public void unmarshal(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        this.colCount = unmarshaller.readInt();
        this.colInfo = new ColInfo[this.colCount + 1];
        boolean dynamicColInfo = false;
        for (int i = 1; i <= this.colCount; ++i) {
            if (i == 1) {
                dynamicColInfo = unmarshaller.readBoolean();
            }
            this.colInfo[i] = dynamicColInfo ? new DynamicColInfo() : new ColInfo();
            this.colInfo[i].unmarshal(unmarshaller);
        }
        int mlen = unmarshaller.readInt();
        if (mlen > 0) {
            for (int i = 0; i < mlen; ++i) {
                this.addUnsupportedMethod((String)unmarshaller.readObject());
            }
        }
    }

    @Override
    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        new ExternalizeDelegate(this).readExternal(in);
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        new ExternalizeDelegate(this).writeExternal(out);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }
}

