/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.jdbc.rowset.impl;

import com.kingdee.jdbc.rowset.impl.SerialArray;
import com.kingdee.jdbc.rowset.impl.SerialBlob;
import com.kingdee.jdbc.rowset.impl.SerialClob;
import com.kingdee.jdbc.rowset.impl.SerialRef;
import com.kingdee.jdbc.rowset.impl.SerialStruct;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;

public class SQLOutputImpl
implements SQLOutput {
    private ArrayList attribs;
    private Map map;

    SQLOutputImpl(ArrayList vector, Map map1) {
        this.attribs = vector;
        this.map = map1;
    }

    @Override
    public void writeArray(Array array) throws SQLException {
        if (array == null) {
            this.attribs.add(array);
            return;
        }
        this.attribs.add(new SerialArray(array, this.map));
    }

    @Override
    public void writeAsciiStream(InputStream inputstream) throws SQLException {
    }

    @Override
    public void writeBigDecimal(BigDecimal bigdecimal) throws SQLException {
        this.attribs.add(bigdecimal);
    }

    @Override
    public void writeBinaryStream(InputStream inputstream) throws SQLException {
    }

    @Override
    public void writeBlob(Blob blob) throws SQLException {
        if (blob == null) {
            this.attribs.add(blob);
            return;
        }
        this.attribs.add(new SerialBlob(blob));
    }

    @Override
    public void writeBoolean(boolean flag) throws SQLException {
        this.attribs.add(flag);
    }

    @Override
    public void writeByte(byte byte0) throws SQLException {
        this.attribs.add(new Byte(byte0));
    }

    @Override
    public void writeBytes(byte[] abyte0) throws SQLException {
        this.attribs.add(abyte0);
    }

    @Override
    public void writeCharacterStream(Reader reader) throws SQLException {
    }

    @Override
    public void writeClob(Clob clob) throws SQLException {
        if (clob == null) {
            this.attribs.add(clob);
            return;
        }
        this.attribs.add(new SerialClob(clob));
    }

    @Override
    public void writeDate(Date date) throws SQLException {
        this.attribs.add(date);
    }

    @Override
    public void writeDouble(double d) throws SQLException {
        this.attribs.add(new Double(d));
    }

    @Override
    public void writeFloat(float f) throws SQLException {
        this.attribs.add(new Float(f));
    }

    @Override
    public void writeInt(int i) throws SQLException {
        this.attribs.add(i);
    }

    @Override
    public void writeLong(long l) throws SQLException {
        this.attribs.add(l);
    }

    @Override
    public void writeObject(SQLData sqldata) throws SQLException {
        if (sqldata == null) {
            this.attribs.add(sqldata);
            return;
        }
        this.attribs.add(new SerialStruct(sqldata, this.map));
    }

    @Override
    public void writeRef(Ref ref) throws SQLException {
        if (ref == null) {
            this.attribs.add(ref);
            return;
        }
        this.attribs.add(new SerialRef(ref));
    }

    @Override
    public void writeShort(short word0) throws SQLException {
        this.attribs.add(new Short(word0));
    }

    @Override
    public void writeString(String s) throws SQLException {
        this.attribs.add(s);
    }

    @Override
    public void writeStruct(Struct struct) throws SQLException {
        SerialStruct serialstruct = new SerialStruct(struct, this.map);
        this.attribs.add(serialstruct);
    }

    @Override
    public void writeTime(Time time) throws SQLException {
        this.attribs.add(time);
    }

    @Override
    public void writeTimestamp(Timestamp timestamp) throws SQLException {
        this.attribs.add(timestamp);
    }

    @Override
    public void writeURL(URL x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeNClob(NClob x) throws SQLException {
    }

    @Override
    public void writeNString(String x) throws SQLException {
    }

    @Override
    public void writeRowId(RowId x) throws SQLException {
    }

    @Override
    public void writeSQLXML(SQLXML x) throws SQLException {
    }
}

