/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.jdbc.rowset.impl;

import com.kingdee.util.marshal.ExternalizeDelegate;
import com.kingdee.util.marshal.IMarshalObject;
import com.kingdee.util.marshal.Marshaller;
import com.kingdee.util.marshal.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class SerialBlob
implements Blob,
IMarshalObject,
Cloneable {
    byte[] buf;
    long len;

    SerialBlob(Blob blob) throws SQLException {
        this.len = blob.length();
        this.buf = blob.getBytes(1L, (int)this.len);
    }

    public SerialBlob(byte[] btyes) throws SQLException {
        this.len = btyes.length;
        this.buf = btyes;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        ByteArrayInputStream bytearrayinputstream = new ByteArrayInputStream(this.buf);
        return bytearrayinputstream;
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        if ((long)length > this.len) {
            length = (int)this.len;
        }
        if (pos < 1L || (long)length - pos < 0L) {
            throw new SQLException("Invalid arguments: position cannot be less that 1");
        }
        --pos;
        byte[] b = new byte[length];
        for (int i = 0; i < length; ++i) {
            b[i] = this.buf[(int)pos];
            ++pos;
        }
        return b;
    }

    @Override
    public long length() throws SQLException {
        return this.len;
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        return this.position(pattern.getBytes(1L, (int)pattern.length()), start);
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        if (start < 1L || start > this.len) {
            return -1L;
        }
        int pos = (int)start - 1;
        int i = 0;
        long patlen = pattern.length;
        while ((long)pos < this.len) {
            if (pattern[i] == this.buf[pos]) {
                if ((long)(i + 1) == patlen) {
                    return (long)(pos + 1) - (patlen - 1L);
                }
                ++i;
                ++pos;
                continue;
            }
            if (pattern[i] == this.buf[pos]) continue;
            ++pos;
        }
        return -1L;
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void truncate(long len) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Object clone() throws CloneNotSupportedException {
        SerialBlob blob = (SerialBlob)super.clone();
        blob.buf = new byte[this.buf.length];
        System.arraycopy(this.buf, 0, blob.buf, 0, this.buf.length);
        blob.len = this.len;
        return blob;
    }

    public SerialBlob() {
    }

    @Override
    public void marshal(Marshaller marshaller) throws IOException {
        marshaller.writeInt((int)this.len);
        int i = 0;
        while ((long)i < this.len) {
            marshaller.writeByte(this.buf[i]);
            ++i;
        }
    }

    @Override
    public void unmarshal(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        this.len = unmarshaller.readInt();
        this.buf = new byte[(int)this.len];
        int i = 0;
        while ((long)i < this.len) {
            this.buf[i] = unmarshaller.readByte();
            ++i;
        }
    }

    @Override
    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        new ExternalizeDelegate(this).readExternal(in);
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        new ExternalizeDelegate(this).writeExternal(out);
    }

    @Override
    public void free() throws SQLException {
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        return null;
    }
}

