/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util;

import com.kingdee.util.BOSResourceInterceptor;
import com.kingdee.util.ResourceBundleEnumeration;
import com.kingdee.util.ResourceBundleUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;

class BOSPropertyResourceBundle
extends ResourceBundle {
    private Locale locale = null;
    private Map lookup = Collections.EMPTY_MAP;
    private String resName;
    private ClassLoader loader;
    private boolean needToReload = false;

    BOSPropertyResourceBundle(InputStream stream, String resName, ClassLoader loader, boolean needToReload) throws IOException {
        this.resName = resName;
        this.needToReload = needToReload;
        this.loader = loader;
        Properties properties = new Properties();
        properties.load(stream);
        this.lookup = BOSResourceInterceptor.isUseInterceptor() ? BOSResourceInterceptor.getPropertyMap(resName, properties) : new HashMap<Object, Object>(properties);
    }

    @Override
    public Object handleGetObject(String key) {
        Object rtv;
        if (key == null) {
            throw new NullPointerException();
        }
        if (this.needToReload) {
            this.reload();
        }
        if ((rtv = this.lookup.get(key)) != null) {
            if ("".equals(rtv.toString().trim())) {
                return ResourceBundleUtil.valueNotFound(this);
            }
            return rtv;
        }
        return ResourceBundleUtil.keyNotFound(this);
    }

    public Enumeration getKeys() {
        if (this.needToReload) {
            this.reload();
        }
        ResourceBundle parent = this.parent;
        return new ResourceBundleEnumeration(this.lookup.keySet(), parent != null ? parent.getKeys() : null);
    }

    ResourceBundle getParent() {
        return this.parent;
    }

    @Override
    protected void setParent(ResourceBundle parent) {
        super.setParent(parent);
    }

    void setLocale(String baseName, String bundleName) {
        if (baseName.length() == bundleName.length()) {
            this.locale = new Locale("", "");
        } else if (baseName.length() < bundleName.length()) {
            int pos = baseName.length();
            String temp = bundleName.substring(pos + 1);
            if ((pos = temp.indexOf(95)) == -1) {
                this.locale = new Locale(temp, "", "");
                return;
            }
            String language = temp.substring(0, pos);
            if ((pos = (temp = temp.substring(pos + 1)).indexOf(95)) == -1) {
                this.locale = new Locale(language, temp, "");
                return;
            }
            String country = temp.substring(0, pos);
            temp = temp.substring(pos + 1);
            this.locale = new Locale(language, country, temp);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void reload() {
        InputStream stream = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (BOSPropertyResourceBundle.this.loader != null) {
                    return BOSPropertyResourceBundle.this.loader.getResourceAsStream(BOSPropertyResourceBundle.this.resName);
                }
                return ClassLoader.getSystemResourceAsStream(BOSPropertyResourceBundle.this.resName);
            }
        });
        if (stream != null) {
            stream = new BufferedInputStream(stream);
            try {
                Properties properties = new Properties();
                properties.load(stream);
                this.lookup = BOSResourceInterceptor.isUseInterceptor() ? BOSResourceInterceptor.getPropertyMap(this.resName, properties) : new HashMap<Object, Object>(properties);
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public void setNeedToReload(boolean needToReload) {
        this.needToReload = needToReload;
        if (this.parent instanceof BOSPropertyResourceBundle) {
            ((BOSPropertyResourceBundle)this.parent).setNeedToReload(needToReload);
        }
    }
}

