/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util;

import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;

public class BOSResourceInterceptor {
    private static final char DEFAULTMASKCHAR = 'X';
    private static final String RESCHECKCFG = "ResCheckCfg";
    private static final String USEINTERCEPTOR = "UseInterceptor";
    private static final String MASKCHAR = "MaskChar";
    private static final String PACKAGES = "Packages";
    private static final String RESOURCES = "Resources";
    private static final String[] imageTypes = new String[]{".gif", ".jpg", ".png", ".bmp"};
    private static boolean useInterceptor = false;
    private static char maskChar = (char)88;
    private static String packages = null;
    private static String resources = null;
    private static String[] packageList = null;
    private static String[] resourceList = null;

    public static Map getPropertyMap(String bundleName, Map properties) {
        if (useInterceptor && BOSResourceInterceptor.isUseInterceptor(bundleName)) {
            return new ResourceMap(properties);
        }
        return new HashMap(properties);
    }

    private static boolean isUseInterceptor(String bundleName) {
        int i;
        int n;
        if (StringUtils.isEmpty(bundleName)) {
            return false;
        }
        String javaName = StringUtils.replace(bundleName, "/", ".");
        javaName = StringUtils.replace(javaName, "\\", ".");
        if (packageList != null) {
            n = packageList.length;
            for (i = 0; i < n; ++i) {
                if (StringUtils.isEmpty(packageList[i]) || !javaName.startsWith(packageList[i])) continue;
                return true;
            }
        }
        if (resourceList != null) {
            n = resourceList.length;
            for (i = 0; i < n; ++i) {
                if (StringUtils.isEmpty(resourceList[i]) || !javaName.equalsIgnoreCase(resourceList[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isUseInterceptor() {
        return useInterceptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        FileInputStream fis = null;
        try {
            String cfgFileName = System.getProperty(RESCHECKCFG);
            if (!StringUtils.isEmpty(cfgFileName) && new File(cfgFileName).exists()) {
                fis = new FileInputStream(cfgFileName);
                Properties cfgProps = new Properties();
                cfgProps.load(fis);
                String isUse = cfgProps.getProperty(USEINTERCEPTOR);
                if (!StringUtils.isEmpty(isUse) && "true".equalsIgnoreCase(isUse)) {
                    String maskString = cfgProps.getProperty(MASKCHAR);
                    maskChar = StringUtils.isEmpty(maskString) ? (char)88 : maskString.charAt(0);
                    packages = cfgProps.getProperty(PACKAGES);
                    if (!StringUtils.isEmpty(packages)) {
                        packageList = StringUtils.split(packages, ";");
                    }
                    if (!StringUtils.isEmpty(resources = cfgProps.getProperty(RESOURCES))) {
                        resourceList = StringUtils.split(resources, ";");
                    }
                    useInterceptor = true;
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static class ResourceMap
    implements Map {
        private Map properties = null;

        public ResourceMap(Map map) {
            this.properties = map == null ? new Hashtable() : map;
        }

        @Override
        public void clear() {
            this.properties.clear();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.properties.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.properties.containsValue(value);
        }

        public Set entrySet() {
            return this.properties.entrySet();
        }

        public Object get(Object key) {
            Object value = this.properties.get(key);
            if (value instanceof String && !StringUtils.isEmpty((String)value)) {
                String newValue = (String)value;
                int n = imageTypes.length;
                for (int i = 0; i < n; ++i) {
                    if (!newValue.endsWith(imageTypes[i])) continue;
                    return value;
                }
                if (key instanceof String && ((String)key).indexOf("formatXml") >= 0) {
                    return ResourceMap.getFormatXMLMaskString(newValue);
                }
                return ResourceMap.getMaskString(newValue);
            }
            return value;
        }

        private static String getMaskString(String value) {
            int length = value.length();
            char[] chars = new char[length];
            for (int i = 0; i < length; ++i) {
                chars[i] = maskChar;
            }
            return new String(chars);
        }

        @Override
        public boolean isEmpty() {
            return this.properties.isEmpty();
        }

        public Set keySet() {
            return this.properties.keySet();
        }

        public Object put(Object key, Object value) {
            return this.properties.put(key, value);
        }

        public void putAll(Map t) {
            this.properties.putAll(t);
        }

        public Object remove(Object key) {
            return this.properties.remove(key);
        }

        @Override
        public int size() {
            return this.properties.size();
        }

        public Collection values() {
            return this.properties.values();
        }

        public static String getFormatXMLMaskString(String formatXml) {
            Namespace NS_TABLE = Namespace.getNamespace((String)"t", (String)"http://www.kingdee.com/Table");
            SAXBuilder sb = new SAXBuilder();
            try {
                Document doc = sb.build((Reader)new StringReader(formatXml));
                Element sheet = doc.getRootElement().getChild("Table").getChild("Sheet", NS_TABLE);
                Element tableNode = sheet.getChild("Table", NS_TABLE);
                Element headNode = tableNode.getChild("Head", NS_TABLE);
                if (headNode != null) {
                    List rowList = headNode.getChildren("Row", NS_TABLE);
                    for (int i = 0; i < rowList.size(); ++i) {
                        Element rowNode = (Element)rowList.get(i);
                        List cellList = rowNode.getChildren("Cell", NS_TABLE);
                        for (int j = 0; j < cellList.size(); ++j) {
                            Element cellNode = (Element)cellList.get(j);
                            String attVal = cellNode.getText();
                            if (StringUtils.isEmpty(attVal)) continue;
                            cellNode.setText(ResourceMap.getMaskString(attVal));
                        }
                    }
                }
                XMLOutputter out = new XMLOutputter();
                return out.outputString(doc);
            }
            catch (Exception e) {
                return formatXml;
            }
        }
    }
}

