/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util;

public class Bitmap {
    private Block[] grid;
    private final int blockSize;

    public Bitmap(int blockSize) {
        this.blockSize = blockSize;
        this.grid = new Block[10];
    }

    public void mark(int pos) {
        this.ensureCapacity(pos + 1);
        int index = pos / (this.blockSize * 32);
        if (this.grid[index] == null) {
            this.grid[index] = new Block(this.blockSize);
        }
        this.grid[index].mark(pos % (this.blockSize * 32));
    }

    private void ensureCapacity(int minCapacity) {
        int oldCapacity = this.grid.length;
        if ((minCapacity = minCapacity / (this.blockSize * 32) + 1) > oldCapacity) {
            Block[] oldData = this.grid;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.grid = new Block[newCapacity];
            System.arraycopy(oldData, 0, this.grid, 0, oldData.length);
        }
    }

    public void clear() {
        this.grid = new Block[10];
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < this.grid.length; ++i) {
            str.append(i + " : ");
            str.append(this.grid[i]);
            str.append("\n\r");
        }
        return str.toString();
    }

    public static void main(String[] args) {
        Bitmap map = new Bitmap(1);
        for (int i = 0; i < 100; ++i) {
            map.mark(i);
        }
        System.out.println(map);
    }

    static class Block {
        private final int[] item;
        private final int capacity;

        Block(int size) {
            this.item = new int[size];
            this.capacity = 32 * size;
        }

        int getCapacity() {
            return this.capacity;
        }

        void mark(int pos) {
            if (pos >= this.capacity || pos < 0) {
                throw new IndexOutOfBoundsException("pos:" + pos);
            }
            int index = pos / 32;
            int num = 1 << pos % 32;
            this.item[index] = this.item[index] | num;
        }

        boolean isHitAll() {
            for (int i : this.item) {
                if (i == -1) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            for (int i = this.item.length - 1; i >= 0; --i) {
                str.append(Integer.toBinaryString(this.item[i]));
            }
            return str.toString();
        }
    }
}

