/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util;

import com.kingdee.util.ConfigurationException;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.XMLConfiguration;
import java.io.File;
import java.io.PrintStream;
import java.net.URL;
import java.util.List;

public class Configuration {
    public static final String SERVER_ROOT_PROP = "bos.root";
    public static final String SERVER_CONFIG_PROP = "bos.config";
    public static final String DEFAULT_SERVER_CONFIG = "bosconfig.xml";
    private XMLConfiguration xmlConfig;
    private File file;
    private URL url;
    private static volatile Configuration myself;

    public static File getServerRoot() {
        String root = System.getProperty(SERVER_ROOT_PROP);
        if (root == null) {
            root = System.getProperty("user.dir");
        }
        return new File(root);
    }

    public static File getFile(String name) {
        File file;
        if (File.separatorChar != '/') {
            name = name.replace('/', File.separatorChar);
        }
        if (!(file = new File(name)).isAbsolute()) {
            file = new File(Configuration.getServerRoot(), name);
        }
        return file;
    }

    private Configuration(String fileName) {
        this.file = Configuration.getFile(fileName);
    }

    private Configuration(URL url) {
        this.url = url;
    }

    public static Configuration getInstance() throws ConfigurationException {
        String fileName = System.getProperty(SERVER_CONFIG_PROP, DEFAULT_SERVER_CONFIG);
        return Configuration.getInstance(fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Configuration getInstance(String fileName) throws ConfigurationException {
        if (myself != null) return myself;
        Class<Configuration> clazz = Configuration.class;
        synchronized (Configuration.class) {
            if (myself != null) return myself;
            Configuration config = new Configuration(fileName);
            config.load();
            myself = config;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return myself;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Configuration getInstance(URL url) throws ConfigurationException {
        if (myself != null) return myself;
        Class<Configuration> clazz = Configuration.class;
        synchronized (Configuration.class) {
            if (myself != null) return myself;
            Configuration config = new Configuration(url);
            config.load();
            myself = config;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return myself;
        }
    }

    public void addConfigItem(ConfigurationItem item) {
        this.xmlConfig.addConfigItem(item);
    }

    public ConfigurationItem getConfigItem(String name) {
        return this.xmlConfig.getConfigItem(name);
    }

    public List getConfigItemList(String name) {
        return this.xmlConfig.getConfigItemList(name);
    }

    public ConfigurationItem getConfigItemByPath(String path) {
        return this.xmlConfig.getConfigItemByPath(path);
    }

    public List getConfigItemListByPath(String path) {
        return this.xmlConfig.getConfigItemListByPath(path);
    }

    public void removeConfigItem(String name) {
        this.xmlConfig.removeConfigItem(name);
    }

    public void removeAll() {
        this.xmlConfig.removeAll();
    }

    public void store() throws ConfigurationException {
        this.xmlConfig.store();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void load() throws ConfigurationException {
        if (this.file == null && this.url == null) {
            throw new ConfigurationException("config file not exists.");
        }
        if (this.file != null) {
            if (!this.file.exists()) throw new ConfigurationException("config file " + this.file.getAbsolutePath() + " not exists.");
            this.xmlConfig = XMLConfiguration.getInstance(this.file);
            return;
        } else {
            if (this.url == null) throw new ConfigurationException("config file not exists.");
            this.xmlConfig = XMLConfiguration.getInstance(this.url);
        }
    }

    public void dump(PrintStream ps) {
        this.xmlConfig.dump(ps);
    }
}

